/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import java.io.File;
import java.util.List;

public class Media
extends Entity {
    private static final TagPath TITLE55 = new TagPath("OBJE:TITL");
    private static final TagPath TITLE551 = new TagPath("OBJE:FILE:TITL");
    private TagPath titlepath = TITLE55;

    public Media(String string, String string2) {
        super(string, string2);
        this.assertTag("OBJE");
    }

    protected String getToStringPrefix(boolean bl) {
        return this.getTitle();
    }

    public boolean addFile(File file) {
        if (!this.getMetaProperty().allows("BLOB")) {
            return super.addFile(file);
        }
        List<PropertyBlob> list = this.getProperties(PropertyBlob.class);
        PropertyBlob propertyBlob = list.isEmpty() ? (PropertyBlob)this.addProperty("BLOB", "") : list.get(0);
        return propertyBlob.addFile(file);
    }

    public File getFile() {
        Property property = this.getProperty("FILE", true);
        return property instanceof PropertyFile ? ((PropertyFile)property).getFile() : null;
    }

    public PropertyBlob getBlob() {
        Property property = this.getProperty("BLOB", true);
        return property instanceof PropertyBlob ? (PropertyBlob)property : null;
    }

    public String getTitle() {
        Property property = this.getProperty(this.titlepath);
        return property == null ? "" : property.getValue();
    }

    void addNotify(Gedcom gedcom) {
        super.addNotify(gedcom);
        this.titlepath = this.getMetaProperty().allows("TITLE") ? TITLE55 : TITLE551;
    }

    public void setTitle(String string) {
        this.setValue(this.titlepath, string);
    }
}

