/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.Note;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Property
implements Comparable<Property> {
    protected static final String UNSUPPORTED_TAG = "Unsupported Tag";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\\{(.*?)\\$(.)(.*?)\\}");
    private Property parent = null;
    private List<Property> children = null;
    protected ImageIcon image;
    protected ImageIcon imageErr;
    protected boolean isTransient = false;
    protected static final Resources resources = Gedcom.resources;
    public static final String LABEL = resources.getString("prop");
    private String tag = null;

    protected Property(String string) {
        this.tag = string;
    }

    void afterAddNotify() {
    }

    void beforeDelNotify() {
        this.delProperties();
    }

    void propagateXRefLinked(PropertyXRef propertyXRef, PropertyXRef propertyXRef2) {
        if (this.parent != null) {
            this.parent.propagateXRefLinked(propertyXRef, propertyXRef2);
        }
    }

    void propagateXRefUnlinked(PropertyXRef propertyXRef, PropertyXRef propertyXRef2) {
        if (this.parent != null) {
            this.parent.propagateXRefUnlinked(propertyXRef, propertyXRef2);
        }
    }

    void propagatePropertyAdded(Property property, int n, Property property2) {
        if (this.parent != null) {
            this.parent.propagatePropertyAdded(property, n, property2);
        }
    }

    void propagatePropertyDeleted(Property property, int n, Property property2) {
        if (this.parent != null) {
            this.parent.propagatePropertyDeleted(property, n, property2);
        }
    }

    void propagatePropertyChanged(Property property, String string) {
        if (this.parent != null) {
            this.parent.propagatePropertyChanged(property, string);
        }
    }

    void propagatePropertyMoved(Property property, Property property2, int n, int n2) {
        if (this.parent != null) {
            this.parent.propagatePropertyMoved(property, property2, n, n2);
        }
    }

    public boolean addFile(File file) {
        return this.addFile(file, "");
    }

    public boolean addFile(File file, String string) {
        if (!this.getMetaProperty().allows("FILE")) {
            if (!this.getMetaProperty().allows("OBJE")) {
                return false;
            }
            return this.addProperty("OBJE", "").addFile(file, string);
        }
        List<PropertyFile> list = this.getProperties(PropertyFile.class);
        PropertyFile propertyFile = list.isEmpty() ? (PropertyFile)this.addProperty("FILE", "") : list.get(0);
        Property property = this.getProperty("TITL");
        if (property != null) {
            property.setValue(string);
        } else if (string.length() > 0) {
            this.addProperty("TITL", string);
        }
        return propertyFile.addFile(file);
    }

    public boolean addNote(Note note) {
        if (!this.getMetaProperty().allows("NOTE")) {
            return false;
        }
        PropertyNote propertyNote = new PropertyNote();
        this.addProperty(propertyNote);
        propertyNote.setValue(note.getId());
        try {
            propertyNote.link();
        }
        catch (GedcomException gedcomException) {
            Gedcom.LOG.log(Level.FINE, "unexpected", gedcomException);
            this.delProperty(propertyNote);
            return false;
        }
        return true;
    }

    public boolean addMedia(Media media) {
        if (!this.getMetaProperty().allows("OBJE")) {
            return false;
        }
        PropertyMedia propertyMedia = new PropertyMedia();
        this.addProperty(propertyMedia);
        propertyMedia.setValue(media.getId());
        try {
            propertyMedia.link();
        }
        catch (GedcomException gedcomException) {
            Gedcom.LOG.log(Level.FINE, "unexpected", gedcomException);
            this.delProperty(propertyMedia);
            return false;
        }
        return true;
    }

    public Property addProperty(String string, String string2) {
        try {
            return this.addProperty(string, string2, -1);
        }
        catch (GedcomException gedcomException) {
            return this.addProperty(new PropertySimpleReadOnly(string, string2), -1);
        }
    }

    public Property addProperty(String string, String string2, int n) throws GedcomException {
        return this.addProperty(this.getMetaProperty().getNested(string, true).create(string2), n);
    }

    public Property addSimpleProperty(String string, String string2, int n) {
        return this.addProperty(new PropertySimpleValue(string, string2), n);
    }

    Property addProperty(Property property) {
        return this.addProperty(property, -1);
    }

    Property addProperty(Property property, int n) {
        if (property.getParent() != null || property.getNoOfProperties() > 0) {
            throw new IllegalArgumentException("Can't add a property that is already contained or contains properties");
        }
        if (n < 0) {
            MetaProperty metaProperty = this.getMetaProperty();
            int n2 = metaProperty.getNestedIndex(property.getTag());
            for (n = 0; n < this.getNoOfProperties() && metaProperty.getNestedIndex(this.getProperty(n).getTag()) <= n2; ++n) {
            }
        } else if (n > this.getNoOfProperties()) {
            n = this.getNoOfProperties();
        }
        if (this.children == null) {
            this.children = new ArrayList<Property>();
        }
        this.children.add(n, property);
        if (this.isTransient) {
            property.isTransient = true;
        }
        property.parent = this;
        this.propagatePropertyAdded(this, n, property);
        property.afterAddNotify();
        return property;
    }

    public void delProperties() {
        if (this.children != null) {
            Property[] propertyArray = this.children.toArray(new Property[this.children.size()]);
            for (int i = propertyArray.length - 1; i >= 0; --i) {
                this.delProperty(propertyArray[i]);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperties(String string) {
        if (this.children != null) {
            Property[] propertyArray = this.children.toArray(new Property[this.children.size()]);
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!propertyArray[i].getTag().equals(string)) continue;
                this.delProperty(propertyArray[i]);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperty(Property property) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no such child");
        }
        if (property == null) {
            throw new IllegalArgumentException("can't delete null property");
        }
        int n = 0;
        while (this.children.get(n) != property) {
            ++n;
        }
        this.delProperty(n);
    }

    public void delProperty(int n) {
        if (this.children == null || n < 0 || n >= this.children.size()) {
            throw new IndexOutOfBoundsException("No property " + n);
        }
        Property property = this.children.get(n);
        property.beforeDelNotify();
        this.children.remove(n);
        property.parent = null;
        this.propagatePropertyDeleted(this, n, property);
    }

    public void moveProperties(List<Property> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            Property property = list.get(i);
            n = this.moveProperty(property, n);
        }
    }

    public int moveProperty(Property property, int n) {
        return this.moveProperty(this.children.indexOf(property), n);
    }

    public int moveProperty(int n, int n2) {
        Property property = this.children.remove(n);
        if (n < n2) {
            --n2;
        }
        this.children.add(n2, property);
        this.propagatePropertyMoved(this, property, n, n2);
        return n2 + 1;
    }

    public String getDeleteVeto() {
        return null;
    }

    public Entity getEntity() {
        return this.parent == null ? null : this.parent.getEntity();
    }

    public Gedcom getGedcom() {
        return this.parent != null ? this.parent.getGedcom() : null;
    }

    public ImageIcon getImage() {
        return this.getImage(false);
    }

    public ImageIcon getImage(boolean bl) {
        if (!bl || this.isValid()) {
            if (this.image == null) {
                this.image = this.getGedcom() != null ? this.getMetaProperty().getImage() : MetaProperty.IMG_CUSTOM;
            }
            return this.image;
        }
        if (this.imageErr == null) {
            this.imageErr = this.getMetaProperty().getImage("err");
        }
        return this.imageErr;
    }

    public int getNoOfProperties() {
        return this.children == null ? 0 : this.children.size();
    }

    public Property getParent() {
        return this.parent;
    }

    public TagPath getPathToNested(Property property) {
        Stack<String> stack = new Stack<String>();
        property.getPathToContaining(this, stack);
        return new TagPath(stack);
    }

    private void getPathToContaining(Property property, Stack<String> stack) {
        stack.push(this.getTag());
        if (property == this) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("couldn't find containing " + property);
        }
        this.parent.getPathToContaining(property, stack);
    }

    public TagPath getPath() {
        return this.getPath(false);
    }

    public TagPath getPath(boolean bl) {
        Stack<String> stack = new Stack<String>();
        String string = this.getTag();
        for (Property property = this.getParent(); property != null; property = property.getParent()) {
            if (bl) {
                Property property2;
                int n = 0;
                int n2 = property.getNoOfProperties();
                for (int i = 0; i < n2 && (property2 = property.getProperty(i)) != this; ++i) {
                    if (!property2.getTag().equals(string)) continue;
                    ++n;
                }
                stack.push(string + "#" + n);
            } else {
                stack.push(string);
            }
            string = property.getTag();
        }
        stack.push(string);
        return new TagPath(stack);
    }

    public boolean contains(Property property) {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Property property2 = this.children.get(i);
            if (property2 != property && !property2.contains(property)) continue;
            return true;
        }
        return false;
    }

    public boolean isContained(Property property) {
        Property property2 = this.getParent();
        if (property2 == property) {
            return true;
        }
        return property2 == null ? false : property2.isContained(property);
    }

    public boolean hasProperties(List<Property> list) {
        return this.children == null ? false : this.children.containsAll(list);
    }

    public Property[] getProperties() {
        return this.children == null ? new Property[]{} : Property.toArray(this.children);
    }

    public List<Property> findProperties(Pattern pattern, Pattern pattern2) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (pattern2 == null) {
            pattern2 = Pattern.compile(".*");
        }
        this.findPropertiesRecursively(arrayList, pattern, pattern2, true);
        return arrayList;
    }

    protected boolean findPropertiesRecursivelyTest(Pattern pattern, Pattern pattern2) {
        return pattern.matcher(this.getTag()).matches() && pattern2.matcher(this.getValue()).matches();
    }

    private void findPropertiesRecursively(Collection<Property> collection, Pattern pattern, Pattern pattern2, boolean bl) {
        if (this.findPropertiesRecursivelyTest(pattern, pattern2)) {
            collection.add(this);
        }
        int n = this.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            if (!bl) continue;
            this.getProperty(i).findPropertiesRecursively(collection, pattern, pattern2, bl);
        }
    }

    public Property[] getProperties(String string) {
        return this.getProperties(string, true);
    }

    public Property[] getProperties(String string, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>(this.getNoOfProperties());
        int n = this.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            Property property = this.getProperty(i);
            if (!property.getTag().equals(string) || bl && !property.isValid()) continue;
            arrayList.add(property);
        }
        return Property.toArray(arrayList);
    }

    public <T> List<T> getProperties(Class<T> clazz) {
        ArrayList arrayList = new ArrayList(10);
        this.getPropertiesRecursively(arrayList, clazz);
        return arrayList;
    }

    private <T> void getPropertiesRecursively(List<T> list, Class<T> clazz) {
        for (int i = 0; i < this.getNoOfProperties(); ++i) {
            Property property = this.getProperty(i);
            if (clazz.isAssignableFrom(property.getClass())) {
                list.add(property);
            }
            property.getPropertiesRecursively(list, clazz);
        }
    }

    public int getPropertyPosition(Property property) {
        if (this.children == null) {
            throw new IllegalArgumentException("no such property");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != property) continue;
            return i;
        }
        throw new IllegalArgumentException("no such property");
    }

    public Property getProperty(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no property " + n);
        }
        return this.children.get(n);
    }

    public Property getProperty(String string) {
        return this.getProperty(string, true);
    }

    public Property getProperty(String string, boolean bl) {
        if (string.indexOf(58) > 0) {
            throw new IllegalArgumentException("Path not allowed");
        }
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Property property = this.children.get(i);
                if (!property.getTag().equals(string) || bl && !property.isValid()) continue;
                return property;
            }
        }
        return null;
    }

    public Property getPropertyByPath(String string) {
        return this.getProperty(new TagPath(string));
    }

    public Property getProperty(TagPath tagPath) {
        return this.getProperty(tagPath, true);
    }

    public Property getProperty(TagPath tagPath, boolean bl) {
        final Property[] propertyArray = new Property[1];
        PropertyVisitor propertyVisitor = new PropertyVisitor(){

            protected boolean leaf(Property property) {
                propertyArray[0] = property;
                return false;
            }
        };
        tagPath.iterate(this, propertyVisitor, bl);
        return propertyArray[0];
    }

    public Property[] getProperties(TagPath tagPath) {
        final ArrayList<Property> arrayList = new ArrayList<Property>(10);
        PropertyVisitor propertyVisitor = new PropertyVisitor(){

            protected boolean leaf(Property property) {
                arrayList.add(property);
                return true;
            }
        };
        tagPath.iterate(this, propertyVisitor);
        return Property.toArray(arrayList);
    }

    public final String getTag() {
        return this.tag;
    }

    public abstract String getValue();

    public String getDisplayValue() {
        return this.getValue();
    }

    public String getPropertyValue(String string) {
        Property property = this.getProperty(string);
        return property != null ? property.getValue() : "";
    }

    public String getPropertyDisplayValue(String string) {
        Property property = this.getProperty(string);
        return property != null ? property.getDisplayValue() : "";
    }

    public String toString() {
        Property property;
        Property property2;
        WordBuffer wordBuffer = new WordBuffer(" ");
        wordBuffer.append(this.getPropertyName());
        String string = this.getDisplayValue();
        if (string.length() > 0) {
            wordBuffer.append(string);
        }
        if ((property2 = this.getProperty("DATE")) instanceof PropertyDate && property2.isValid()) {
            wordBuffer.append(property2.getDisplayValue());
        }
        if ((property = this.getProperty("PLAC")) != null) {
            String string2 = property.getDisplayValue();
            if (string2.length() > 0) {
                wordBuffer.append(property.getDisplayValue());
            }
        } else {
            String string3;
            Property property3;
            Property property4 = this.getProperty("ADDR");
            if (property4 != null && (property3 = property4.getProperty("CITY")) != null && (string3 = property3.getDisplayValue()).length() > 0) {
                wordBuffer.append(string3);
            }
        }
        return wordBuffer.toString();
    }

    public String getValue(TagPath tagPath, String string) {
        Property property = this.getProperty(tagPath);
        return property == null ? string : property.getValue();
    }

    public Property setValue(TagPath tagPath, final String string) {
        final Property[] propertyArray = new Property[1];
        PropertyVisitor propertyVisitor = new PropertyVisitor(){

            protected boolean leaf(Property property) {
                if (property instanceof PropertyXRef && ((PropertyXRef)property).getTarget() != null) {
                    property = property.getParent().addProperty(property.getTag(), "");
                }
                property.setValue(string);
                propertyArray[0] = property;
                return false;
            }

            protected boolean recursion(Property property, String string2) {
                if (property.getProperty(string2, false) == null) {
                    property.addProperty(string2, "");
                }
                return true;
            }
        };
        tagPath.iterate(this, propertyVisitor);
        return propertyArray[0];
    }

    public abstract void setValue(String var1);

    public boolean isValid() {
        return true;
    }

    @Override
    public int compareTo(Property property) {
        return this.compare(this.getDisplayValue(), property.getDisplayValue());
    }

    protected int compare(String string, String string2) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom != null) {
            return gedcom.getCollator().compare(string, string2);
        }
        return string.compareTo(string2);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isReadOnly() {
        return false;
    }

    public final Property addDefaultProperties() {
        if (this.getEntity() == null) {
            throw new IllegalArgumentException("addDefaultProperties() while getEntity()==null!");
        }
        MetaProperty[] metaPropertyArray = this.getNestedMetaProperties(2);
        for (int i = 0; i < metaPropertyArray.length; ++i) {
            if (this.getProperty(metaPropertyArray[i].getTag()) != null) continue;
            this.addProperty(metaPropertyArray[i].getTag(), "").addDefaultProperties();
        }
        return this;
    }

    public MetaProperty getMetaProperty() {
        return this.getGedcom().getGrammar().getMeta(this.getPath());
    }

    public MetaProperty[] getNestedMetaProperties(int n) {
        return this.getMetaProperty().getAllNested(this, n);
    }

    public static Property[] toArray(Collection<Property> collection) {
        return collection.toArray(new Property[collection.size()]);
    }

    public String getPropertyInfo() {
        return this.getMetaProperty().getInfo();
    }

    public String getPropertyName() {
        return Gedcom.getName(this.getTag());
    }

    public static String getPropertyNames(Iterable<? extends Property> iterable, int n) {
        WordBuffer wordBuffer = new WordBuffer(", ");
        int n2 = 0;
        for (Property property : iterable) {
            if (n2 == n) {
                wordBuffer.append("...");
                break;
            }
            wordBuffer.append(property.getPropertyName());
        }
        return wordBuffer.toString();
    }

    public static List<Property> normalize(List<? extends Property> list) {
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        for (Property property : list) {
            Property property2;
            if (property.isTransient()) continue;
            for (property2 = property.getParent(); property2 != null && !list.contains(property2); property2 = property2.getParent()) {
            }
            if (property2 != null) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public String format(String string) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            String string2;
            Property property;
            stringBuffer.append(string.substring(n2, matcher.start()));
            String string3 = matcher.group(1);
            char c = string.charAt(matcher.start(2));
            String string4 = matcher.group(3);
            switch (c) {
                case 'D': {
                    property = this.getProperty("DATE");
                    string2 = property instanceof PropertyDate && property.isValid() ? property.getDisplayValue() : "";
                    break;
                }
                case 'y': {
                    property = this.getProperty("DATE");
                    string2 = property instanceof PropertyDate && property.isValid() ? Integer.toString(((PropertyDate)property).getStart().getYear()) : "";
                    break;
                }
                case 'p': {
                    property = this.getProperty("PLAC");
                    String string5 = string2 = property instanceof PropertyPlace ? ((PropertyPlace)property).getCity() : "";
                    if (string2 != null) break;
                    string2 = "";
                    break;
                }
                case 'P': {
                    property = this.getProperty("PLAC");
                    string2 = property instanceof PropertyPlace ? property.getDisplayValue() : "";
                    break;
                }
                case 'v': {
                    property = this;
                    string2 = this.getDisplayValue();
                    break;
                }
                case 'V': {
                    property = this;
                    string2 = this.getValue();
                    break;
                }
                case 't': {
                    property = null;
                    string2 = this.getTag();
                    break;
                }
                case 'T': {
                    property = null;
                    string2 = Gedcom.getName(this.getTag());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown formatting marker " + c);
                }
            }
            if (string2.length() > 0) {
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(string4);
                if (property != null) {
                    ++n;
                }
            }
            n2 = matcher.end();
        }
        stringBuffer.append(string.substring(n2));
        return n > 0 ? stringBuffer.toString() : "";
    }

    public PropertyDate getWhen() {
        for (Property property = this; property != null; property = property.getParent()) {
            if (this instanceof PropertyDate) {
                return (PropertyDate)this;
            }
            if (!(this instanceof PropertyEvent)) continue;
            return ((PropertyEvent)this).getDate();
        }
        return null;
    }

    public void copyProperties(Property[] propertyArray, boolean bl) throws GedcomException {
        for (Property property : propertyArray) {
            this.copyProperties(property, bl);
        }
    }

    public void copyProperties(Property property, boolean bl) throws GedcomException {
        Property property2 = this.getProperty(property.getTag(), false);
        if (property2 == null) {
            property2 = this.addProperty(property.getTag(), bl ? property.getValue() : "");
            if (bl && property2 instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)property2).link();
                }
                catch (GedcomException gedcomException) {
                    throw new GedcomException("Can't copy '" + property.getTag() + " " + property.getDisplayValue() + "' to " + this.getPath() + ": " + gedcomException.getMessage());
                }
            }
        }
        int n = property.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            Property property3 = property.getProperty(i);
            if (property3.isTransient()) continue;
            property2.copyProperties(property3, bl);
        }
    }

    protected void assertTag(String string) {
        if (!this.tag.equals(string)) {
            throw new Error("Tag should be " + string + " but is " + this.tag);
        }
    }
}

