/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Media;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertySimpleValue;
import genj.util.Base64;
import genj.util.ByteArray;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;

public class PropertyBlob
extends Property
implements MultiLineProperty {
    private Object content = "";

    public PropertyBlob() {
        super("BLOB");
    }

    public PropertyBlob(String string) {
        super(string);
    }

    public byte[] getBlobData() {
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        try {
            this.content = Base64.decode(this.content.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Gedcom.LOG.log(Level.WARNING, "Cannot convert blob base64 in " + this.getGedcom().getName() + "/" + this.getEntity() + "/" + this.getPath() + " into bytes (" + illegalArgumentException.getMessage() + ")");
            return new byte[0];
        }
        return (byte[])this.content;
    }

    public String getTitle() {
        Entity entity = this.getEntity();
        return entity instanceof Media ? ((Media)entity).getTitle() : this.getTag();
    }

    public String getValue() {
        if (this.content instanceof byte[]) {
            return ((byte[])this.content).length + " Raw Bytes";
        }
        return this.content.toString().length() + " Base64 Bytes";
    }

    public MultiLineProperty.Collector getLineCollector() {
        return new BlobCollector();
    }

    public MultiLineProperty.Iterator getLineIterator() {
        if (this.content instanceof byte[]) {
            return new BlobIterator(Base64.encode((byte[])this.content));
        }
        return new BlobIterator(this.content.toString());
    }

    public synchronized void setValue(String string) {
        String string2 = this.getValue();
        this.content = string;
        this.propagatePropertyChanged(this, string2);
    }

    public boolean addFile(File file) {
        return this.load(file.getAbsolutePath(), true);
    }

    public boolean load(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = this.getValue();
        if (string.length() != 0) {
            try {
                object2 = this.getGedcom().getOrigin().open(string);
                object = new ByteArray((InputStream)object2, ((InputStream)object2).available(), false).getBytes();
                ((InputStream)object2).close();
                this.content = object;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        this.propagatePropertyChanged(this, string2);
        object2 = this.getParent();
        if (!bl || !(object2 instanceof PropertyMedia) && !(object2 instanceof Media)) {
            return true;
        }
        object = ((Property)object2).getProperty("FORM");
        if (object == null) {
            object = ((Property)object2).addProperty(new PropertySimpleValue("FORM"));
        }
        ((Property)object).setValue(PropertyFile.getSuffix(string));
        return true;
    }

    private static class BlobIterator
    implements MultiLineProperty.Iterator {
        private String base64;
        private int offset;
        private final int LINE = 72;

        public BlobIterator(String string) {
            this.base64 = string;
            this.offset = 0;
        }

        public void setValue(String string) {
        }

        public int getIndent() {
            return this.offset == 0 ? 0 : 1;
        }

        public String getTag() {
            return this.offset == 0 ? this.getTag() : "CONT";
        }

        public String getValue() {
            return this.base64.substring(this.offset, Math.min(this.offset + 72, this.base64.length()));
        }

        public boolean next() {
            if (this.offset + 72 >= this.base64.length()) {
                return false;
            }
            this.offset += 72;
            return true;
        }
    }

    private class BlobCollector
    implements MultiLineProperty.Collector {
        private StringBuffer buffer = new StringBuffer(1024);

        private BlobCollector() {
            if (PropertyBlob.this.content instanceof String) {
                this.buffer.append(PropertyBlob.this.content);
            }
        }

        public boolean append(int n, String string, String string2) {
            if (n != 1) {
                return false;
            }
            if (!"CONT".equals(string)) {
                return false;
            }
            this.buffer.append(string2.trim());
            return true;
        }

        public String getValue() {
            return this.buffer.toString();
        }
    }
}

