/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.List;

public class PropertyChild
extends PropertyXRef {
    private static final TagPath PATH_FAMCHIL = new TagPath("FAM:CHIL");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_FAMCHIL).getImage();

    PropertyChild() {
        super("CHIL");
    }

    PropertyChild(String string) {
        super(string);
        this.assertTag("CHIL");
    }

    public Indi getChild() {
        return (Indi)this.getTargetEntity();
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.chil.veto");
    }

    public void link() throws GedcomException {
        Fam fam;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        Indi indi = (Indi)this.getCandidate();
        if (indi.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", indi.toString(), fam.toString()));
        }
        List<PropertyFamilyChild> list = indi.getProperties(PropertyFamilyChild.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PropertyFamilyChild propertyFamilyChild = list.get(i);
            if (!propertyFamilyChild.isCandidate(fam)) continue;
            this.link(propertyFamilyChild);
            return;
        }
        PropertyFamilyChild propertyFamilyChild = new PropertyFamilyChild();
        indi.addProperty(propertyFamilyChild);
        this.link(propertyFamilyChild);
    }

    public static String getLabelChildAlreadyinFamily(Indi indi, Fam fam) {
        return resources.getString("error.already.child", indi.toString(), fam.toString());
    }

    public String getTargetType() {
        return "INDI";
    }

    public ImageIcon getImage(boolean bl) {
        Indi indi = this.getChild();
        if (indi == null) {
            return super.getImage(bl);
        }
        switch (indi.getSex()) {
            case 1: {
                return this.overlay(IMG_MALE);
            }
            case 2: {
                return this.overlay(IMG_FEMALE);
            }
        }
        return this.overlay(IMG_UNKNOWN);
    }
}

