/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.util.swing.ImageIcon;

public class PropertyEvent
extends Property {
    public static ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:EVEN")).getImage();
    private boolean knownToHaveHappened;

    public PropertyEvent(String string) {
        super(string);
    }

    public PropertyDate getDate() {
        return this.getDate(true);
    }

    public PropertyDate getDate(boolean bl) {
        Property property = this.getProperty("DATE", bl);
        if (property == null) {
            return null;
        }
        return (PropertyDate)property;
    }

    public String getDateAsString() {
        Property property = this.getProperty("DATE");
        return property != null ? property.getValue() : "";
    }

    public String getValue() {
        return this.knownToHaveHappened ? "Y" : "";
    }

    public void setValue(String string) {
        this.setKnownToHaveHappened(string.toLowerCase().equals("y"));
    }

    void propagatePropertyChanged(Property property, String string) {
        super.propagatePropertyChanged(property, string);
        if (property instanceof PropertyDate && this.getProperty("DATE") == property && this.getParent() instanceof Indi) {
            if (this.getParent().getProperty("BIRT") == this) {
                for (PropertyEvent propertyEvent : this.getParent().getProperties(PropertyEvent.class)) {
                    if (propertyEvent == this) continue;
                    propertyEvent.updateAge((PropertyDate)property);
                }
            } else if (!"BIRT".equals(this.getTag())) {
                this.updateAge();
            }
        }
    }

    public void updateAge() {
        if (!(this.getParent() instanceof Indi)) {
            return;
        }
        this.updateAge(((Indi)this.getParent()).getBirthDate());
    }

    void updateAge(PropertyDate propertyDate) {
        PropertyDate propertyDate2 = this.getDate(true);
        if (propertyDate2 == propertyDate) {
            return;
        }
        PropertyAge propertyAge = (PropertyAge)this.getProperty("AGE");
        if (propertyAge == null) {
            if (propertyDate2 == null || !Options.getInstance().isAddAge) {
                return;
            }
            propertyAge = (PropertyAge)this.addProperty("AGE", "");
        }
        if (propertyDate2 == null || propertyDate == null || !propertyDate.isValid()) {
            return;
        }
        if (propertyDate.getStart().compareTo(propertyDate2.getStart()) >= 0) {
            propertyAge.setValue("");
        } else {
            propertyAge.setValue(Delta.get(propertyDate.getStart(), propertyDate2.getStart()));
        }
    }

    public static TagPath[] getTagPaths(Gedcom gedcom) {
        return gedcom.getGrammar().getAllPaths(null, PropertyEvent.class);
    }

    public Boolean isKnownToHaveHappened() {
        if (this.getTag().equals("EVEN")) {
            return null;
        }
        return new Boolean(this.knownToHaveHappened);
    }

    public void setKnownToHaveHappened(boolean bl) {
        String string = this.getValue();
        this.knownToHaveHappened = bl;
        this.propagatePropertyChanged(this, string);
    }
}

