/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import java.util.List;

public class PropertyFamilyChild
extends PropertyXRef {
    PropertyFamilyChild() {
        super("FAMC");
    }

    PropertyFamilyChild(String string) {
        super(string);
        this.assertTag("FAMC");
    }

    public Boolean isBiological() {
        String string = this.getParent().getTag();
        if ("ADOP".equals(string)) {
            return Boolean.FALSE;
        }
        if ("BIRT".equals(string)) {
            return Boolean.TRUE;
        }
        Property property = this.getProperty("PEDI");
        if (property != null) {
            String string2 = property.getValue();
            if (string2.indexOf("birth") >= 0) {
                return Boolean.TRUE;
            }
            if (string2.indexOf("adopted") >= 0) {
                return Boolean.FALSE;
            }
            if (string2.indexOf("foster") >= 0) {
                return Boolean.FALSE;
            }
            if (string2.indexOf("sealing") >= 0) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected String getForeignDisplayValue() {
        Property property = this.getParent();
        if (property instanceof PropertyEvent && property.getTag().equals("ADOP")) {
            return resources.getString("foreign.ADOP", this.getEntity().toString());
        }
        return super.getForeignDisplayValue();
    }

    public Fam getFamily() {
        return (Fam)this.getTargetEntity();
    }

    public void link() throws GedcomException {
        Indi indi;
        try {
            indi = (Indi)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            throw new GedcomException(resources.getString("error.noenclosingindi"));
        }
        Fam fam = (Fam)this.getCandidate();
        if (indi.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", indi.toString(), fam.toString()));
        }
        List<PropertyChild> list = fam.getProperties(PropertyChild.class);
        for (PropertyChild propertyChild : list) {
            if (!propertyChild.isCandidate(indi)) continue;
            this.link(propertyChild);
            return;
        }
        PropertyChild propertyChild = new PropertyChild();
        fam.addProperty(propertyChild);
        this.link(propertyChild);
    }

    public String getTargetType() {
        return "FAM";
    }
}

