/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.util.EnvironmentChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Logger;

public class CachingStreamHandler
extends URLStreamHandler {
    private static final long EXPIRE_MILLIS = 0L;
    private static final Logger LOG = Logger.getLogger("genj.io");
    private File cache;

    public CachingStreamHandler(String string) {
        this.cache = new File(EnvironmentChecker.getProperty("user.home.genj", null, "local cache home"), string);
        if (!this.cache.isDirectory() && !this.cache.mkdir()) {
            LOG.warning("caching disable - can't write to " + this.cache);
            this.cache = null;
        }
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return new Connection(uRL);
    }

    protected File getCacheEntry(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getFile();
        String string3 = "";
        int n = string2.lastIndexOf(47);
        if (n > 0) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        String string4 = "";
        int n2 = string2.indexOf(63);
        if (n2 > 0) {
            string4 = '-' + Integer.toString(Math.abs(string2.substring(n2).hashCode()));
            string2 = string2.substring(0, n2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        String string5 = "";
        int n3 = string2.lastIndexOf(46);
        if (n3 >= 0) {
            string5 = string2.substring(n3);
            string2 = string2.substring(0, n3);
        }
        return new File(this.cache, string + '/' + string3 + '/' + string2 + string4 + string5);
    }

    private class CachingInputStream
    extends InputStream {
        private URL url;
        private File tmp;
        private File cached;
        private int len;
        private URLConnection con;
        private OutputStream out;
        private InputStream in;

        private CachingInputStream(URL uRL, File file) throws IOException {
            this.url = new URL(uRL.toString());
            this.cached = file;
        }

        private void open() throws IOException {
            if (this.in != null) {
                return;
            }
            try {
                this.con = this.url.openConnection();
                this.in = this.con.getInputStream();
            }
            catch (IOException iOException) {
                if (this.cached.exists()) {
                    LOG.fine("Falling back to cached copy of wiki file " + this.url);
                    this.in = new FileInputStream(this.cached);
                    this.con = null;
                    return;
                }
                throw iOException;
            }
            try {
                this.tmp = new File(this.cached.getAbsolutePath() + ".tmp");
                this.tmp.getParentFile().mkdirs();
                this.out = new FileOutputStream(this.tmp);
            }
            catch (IOException iOException) {
                LOG.fine("can't write cached copy of wiki file " + this.url);
            }
        }

        public int read() throws IOException {
            this.open();
            int n = this.in.read();
            if (this.out != null) {
                this.out.write(n);
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            this.open();
            int n = this.in.read(byArray);
            if (n > 0 && this.out != null) {
                this.out.write(byArray, 0, n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.open();
            int n3 = this.in.read(byArray, n, n2);
            if (n3 > 0 && this.out != null) {
                this.out.write(byArray, n, n3);
            }
            return n3;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                if (this.con != null) {
                    if (this.tmp.length() == (long)this.con.getContentLength()) {
                        this.tmp.renameTo(this.cached);
                    } else {
                        LOG.fine("not caching " + this.tmp.length() + " copy of " + this.con.getContentLength() + " wiki file " + CachingStreamHandler.this.cache);
                    }
                }
                this.tmp.delete();
            }
            if (this.in != null) {
                this.in.close();
            }
        }
    }

    private class Connection
    extends URLConnection {
        public Connection(URL uRL) {
            super(uRL);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            if (CachingStreamHandler.this.cache != null) {
                URL uRL = this.getURL();
                File file = CachingStreamHandler.this.getCacheEntry(uRL);
                if (file.exists() && file.lastModified() > System.currentTimeMillis() - 0L) {
                    LOG.fine("Using cached copy of wiki file " + this.getURL());
                    return new FileInputStream(file);
                }
                return new CachingInputStream(this.getURL(), file);
            }
            return this.getURL().openStream();
        }
    }
}

