/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public interface Filter {
    public String getName();

    public boolean veto(Property var1);

    public boolean veto(Entity var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Union
    implements Filter {
        private Set<Property> vetoed = new HashSet<Property>();

        public Union(Gedcom gedcom, Collection<Filter> collection) {
            for (Entity property : gedcom.getEntities()) {
                this.scan(property, collection);
            }
            ArrayDeque<Property> arrayDeque = new ArrayDeque<Property>(this.vetoed);
            while (!arrayDeque.isEmpty()) {
                Property property = (Property)arrayDeque.removeLast();
                for (PropertyXRef propertyXRef : property.getProperties(PropertyXRef.class)) {
                    PropertyXRef propertyXRef2;
                    if (!propertyXRef.isValid() || !this.vetoed.add(propertyXRef2 = propertyXRef.getTarget())) continue;
                    arrayDeque.add(propertyXRef2);
                }
            }
        }

        private void scan(Entity entity, Collection<Filter> collection) {
            if (this.isVetoed(entity, collection)) {
                this.vetoed.add(entity);
            } else {
                for (Property property : entity.getProperties()) {
                    this.scan(property, collection);
                }
            }
        }

        private void scan(Property property, Collection<Filter> collection) {
            if (this.isVetoed(property, collection)) {
                this.vetoed.add(property);
            } else {
                for (Property property2 : property.getProperties()) {
                    this.scan(property2, collection);
                }
            }
        }

        private boolean isVetoed(Entity entity, Collection<Filter> collection) {
            for (Filter filter : collection) {
                if (!filter.veto(entity)) continue;
                return true;
            }
            return false;
        }

        private boolean isVetoed(Property property, Collection<Filter> collection) {
            for (Filter filter : collection) {
                if (!filter.veto(property)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getName() {
            return "Union";
        }

        @Override
        public boolean veto(Property property) {
            return this.vetoed.contains(property);
        }

        @Override
        public boolean veto(Entity entity) {
            return this.vetoed.contains(entity);
        }
    }
}

