/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.Version;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.time.PointInTime;
import genj.io.AnselCharset;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomIOException;
import genj.io.PropertyWriter;
import genj.util.Trackable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomWriter
implements Trackable {
    private static Logger LOG = Logger.getLogger("genj.io");
    private Gedcom gedcom;
    private BufferedWriter out;
    private String file;
    private String date;
    private String time;
    private int total;
    private int line;
    private int entity;
    private boolean cancel = false;
    private Filter filter;

    public GedcomWriter(Gedcom gedcom, OutputStream outputStream) throws IOException, GedcomEncodingException {
        Calendar calendar = Calendar.getInstance();
        this.gedcom = gedcom;
        this.file = gedcom.getOrigin() == null ? "Uknown" : gedcom.getOrigin().getFileName();
        this.line = 0;
        this.date = PointInTime.getNow().getValue();
        this.time = new SimpleDateFormat("HH:mm:ss").format(calendar.getTime());
        this.filter = new Filter.Union(this.gedcom, Collections.<Filter>emptyList());
        CharsetEncoder charsetEncoder = this.getCharset(false, outputStream, gedcom.getEncoding()).newEncoder();
        charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.out = new BufferedWriter(new OutputStreamWriter(outputStream, charsetEncoder));
    }

    private Charset getCharset(boolean bl, OutputStream outputStream, String string) throws GedcomEncodingException {
        try {
            if ("UNICODE".equals(string)) {
                if (bl) {
                    try {
                        outputStream.write(GedcomEncodingSniffer.BOM_UTF16BE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Charset.forName("UTF-16BE");
            }
            if ("UTF-8".equals(string)) {
                if (bl) {
                    try {
                        outputStream.write(GedcomEncodingSniffer.BOM_UTF8);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Charset.forName("UTF-8");
            }
            if ("ASCII".equals(string)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("LATIN1".equals(string)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("ANSI".equals(string)) {
                return Charset.forName("Windows-1252");
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        if ("ANSEL".equals(string)) {
            return new AnselCharset();
        }
        throw new GedcomEncodingException("Can't write with unknown encoding " + string);
    }

    @Override
    public void cancelTrackable() {
        this.cancel = true;
    }

    @Override
    public int getProgress() {
        if (this.entity == 0) {
            return 0;
        }
        return this.entity * 100 / this.total;
    }

    @Override
    public String getState() {
        return this.line + " Lines & " + this.entity + " Entities";
    }

    public void setFilters(Collection<Filter> collection) {
        this.filter = new Filter.Union(this.gedcom, collection);
    }

    public int getLines() {
        return this.line;
    }

    public void write() throws GedcomIOException {
        if (this.gedcom == null) {
            throw new IllegalStateException("can't call write() twice");
        }
        List<Entity> list = this.gedcom.getEntities();
        this.total = list.size();
        try {
            this.writeHeader();
            this.writeEntities(list);
            this.writeTail();
            this.out.close();
        }
        catch (GedcomIOException gedcomIOException) {
            throw gedcomIOException;
        }
        catch (Exception exception) {
            throw new GedcomIOException("Error while writing / " + exception.getMessage(), this.line);
        }
        finally {
            this.gedcom = null;
        }
    }

    private void writeLine(String string) throws IOException {
        this.out.write(string);
        this.out.newLine();
        ++this.line;
    }

    private void writeHeader() throws IOException {
        this.writeLine("0 HEAD");
        this.writeLine("1 SOUR GENJ");
        this.writeLine("2 VERS " + Version.getInstance());
        this.writeLine("2 NAME GenealogyJ");
        this.writeLine("2 CORP Nils Meier");
        this.writeLine("3 ADDR http://genj.sourceforge.net");
        this.writeLine("1 DEST ANY");
        this.writeLine("1 DATE " + this.date);
        this.writeLine("2 TIME " + this.time);
        if (this.gedcom.getSubmitter() != null) {
            this.writeLine("1 SUBM @" + this.gedcom.getSubmitter().getId() + '@');
        }
        this.writeLine("1 FILE " + this.file);
        this.writeLine("1 GEDC");
        this.writeLine("2 VERS " + this.gedcom.getGrammar().getVersion());
        this.writeLine("2 FORM Lineage-Linked");
        this.writeLine("1 CHAR " + this.gedcom.getEncoding());
        if (this.gedcom.getLanguage() != null) {
            this.writeLine("1 LANG " + this.gedcom.getLanguage());
        }
        if (this.gedcom.getPlaceFormat().length() > 0) {
            this.writeLine("1 PLAC");
            this.writeLine("2 FORM " + this.gedcom.getPlaceFormat());
        }
    }

    private void writeEntities(List<Entity> list) throws IOException {
        for (Entity entity : list) {
            if (this.cancel) {
                throw new GedcomIOException("Operation cancelled", this.line);
            }
            if (this.filter.veto(entity)) continue;
            try {
                this.line += new EntityWriter().write(0, entity);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                throw new GedcomEncodingException(entity, this.gedcom.getEncoding());
            }
            ++this.entity;
        }
    }

    private void writeTail() throws IOException {
        this.writeLine("0 TRLR");
    }

    private class EntityWriter
    extends PropertyWriter {
        EntityWriter() {
            super(GedcomWriter.this.out, false);
        }

        protected void writeProperty(int n, Property property) throws IOException {
            if (!property.isTransient() && GedcomWriter.this.filter.veto(property)) {
                return;
            }
            super.writeProperty(n, property);
        }
    }
}

