/*
 * Decompiled with CFR 0.152.
 */
package genj.layout;

import genj.app.PluginFactory;
import genj.app.Workbench;
import genj.app.WorkbenchAdapter;
import genj.gedcom.Context;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import genj.view.ActionProvider;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LayoutPlugin
extends WorkbenchAdapter
implements PluginFactory,
ActionProvider {
    private static final String LAYOUT_RESEARCH = "research";
    private static final String LAYOUT_PRESENTATION = "presentation";
    private static final ImageIcon IMG = new ImageIcon(Workbench.class, "images/Layout.png");
    private static final Logger LOG = Logger.getLogger("genj.layout");
    private static final Resources RES = Resources.get(LayoutPlugin.class);
    private static final Registry REGISTRY = Registry.get(Workbench.class);
    private Workbench workbench;
    private Set<String> layouts = new HashSet<String>();

    public Object createPlugin(Workbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(this);
        File file = this.dir();
        if (!file.isDirectory() && !file.mkdirs()) {
            LOG.warning("No layout directory " + file);
        } else {
            for (File file2 : file.listFiles()) {
                String string = file2.getName();
                if (!string.endsWith(".xml")) continue;
                this.layouts.add(string.substring(0, string.length() - 4));
            }
        }
        this.layouts.add(LAYOUT_RESEARCH);
        this.layouts.add(LAYOUT_PRESENTATION);
        this.load(REGISTRY.get("layout", LAYOUT_RESEARCH));
        return this;
    }

    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        if (purpose != ActionProvider.Purpose.MENU) {
            return;
        }
        ActionProvider.ViewActionGroup viewActionGroup = new ActionProvider.ViewActionGroup();
        group.add(viewActionGroup);
        Action2.Group group2 = new Action2.Group(RES.getString("layout"), IMG);
        viewActionGroup.add(group2);
        for (String string : this.layouts) {
            group2.add(new Switch(string));
        }
        group2.add(new ActionProvider.SeparatorAction());
        group2.add(new New());
        group2.add(new Del());
    }

    public void workbenchClosing(Workbench workbench) {
        this.save();
    }

    private File dir() {
        return new File(EnvironmentChecker.getProperty("user.home.genj/layouts", ".", "looking for layouts"));
    }

    private void save() {
        String string = REGISTRY.get("layout", (String)null);
        if (string == null) {
            return;
        }
        File file = new File(this.dir(), string + ".xml");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.workbench.saveLayout(new OutputStreamWriter(fileOutputStream));
            ((OutputStream)fileOutputStream).close();
            LOG.log(Level.FINE, "Wrote layout " + string + " into " + file);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Couldn't write layout " + string + " into " + file, throwable);
        }
    }

    private boolean load(String string) {
        File file = new File(this.dir(), string + ".xml");
        try {
            String string2;
            InputStream inputStream;
            if (file.exists()) {
                inputStream = new FileInputStream(file);
                string2 = "Read layout " + string + " from " + file;
            } else {
                inputStream = this.getClass().getResourceAsStream(string + ".xml");
                string2 = "Read pre-defined layout " + string;
            }
            this.workbench.loadLayout(new InputStreamReader(inputStream));
            inputStream.close();
            LOG.log(Level.INFO, string2);
            REGISTRY.put("layout", string);
            return true;
        }
        catch (Throwable throwable) {
            REGISTRY.put("layout", (String)null);
            LOG.log(Level.WARNING, "Couldn't read layout for key " + string + " from " + file, throwable);
            return false;
        }
    }

    private String name(String string) {
        return RES.getString("layout." + string, false);
    }

    private class Del
    extends Action2 {
        private List<String> choices;

        public Del() {
            this.setText(RES.getString("layout.del"));
            this.choices = new ArrayList<String>(LayoutPlugin.this.layouts);
            ListIterator<String> listIterator = this.choices.listIterator();
            while (listIterator.hasNext()) {
                if (LayoutPlugin.this.name(listIterator.next()) == null) continue;
                listIterator.remove();
            }
            Collections.sort(this.choices);
            this.setEnabled(!this.choices.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DialogHelper.openDialog(this.getText(), 3, RES.getString("layout.name"), this.choices, (Object)actionEvent);
            if (string == null) {
                return;
            }
            File file = new File(LayoutPlugin.this.dir(), string + ".xml");
            if (file.exists() && !file.delete()) {
                return;
            }
            LayoutPlugin.this.layouts.remove(string);
            if (string.equals(REGISTRY.get("layout", (String)null))) {
                LayoutPlugin.this.load(LayoutPlugin.LAYOUT_RESEARCH);
            }
        }
    }

    private class New
    extends Action2 {
        public New() {
            this.setText(RES.getString("layout.new"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DialogHelper.openDialog(this.getText(), 3, RES.getString("layout.name"), "", (Object)actionEvent);
            if (string == null || LayoutPlugin.this.layouts.contains(string)) {
                return;
            }
            LayoutPlugin.this.layouts.add(string);
            REGISTRY.put("layout", string);
        }
    }

    private class Switch
    extends Action2 {
        private String layout;

        public Switch(String string) {
            this.layout = string;
            String string2 = LayoutPlugin.this.name(string);
            this.setText(string2 != null ? string2 : string);
            if (string.equals(REGISTRY.get("layout", ""))) {
                this.setSelected(true);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayoutPlugin.this.save();
            LayoutPlugin.this.load(this.layout);
        }
    }
}

