/*
 * Decompiled with CFR 0.152.
 */
package genj.nav;

import genj.app.PluginFactory;
import genj.app.Workbench;
import genj.gedcom.Context;
import genj.gedcom.Indi;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.view.ActionProvider;
import genj.view.SelectionSink;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NavigatorPluginFactory
implements PluginFactory,
ActionProvider {
    private static final Resources RES = Resources.get(NavigatorPluginFactory.class);
    private static final ImageIcon PARENTS = new ImageIcon(NavigatorPluginFactory.class, "Parents.png");
    private static final ImageIcon SIBLINGS = new ImageIcon(NavigatorPluginFactory.class, "Siblings.png");
    private static final ImageIcon HUSBAND = new ImageIcon(NavigatorPluginFactory.class, "Husband.png");
    private static final ImageIcon WIFE = new ImageIcon(NavigatorPluginFactory.class, "Wife.png");
    private static final ImageIcon CHILDREN = new ImageIcon(NavigatorPluginFactory.class, "Children.png");

    public Object createPlugin(Workbench workbench) {
        return this;
    }

    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        if (purpose != ActionProvider.Purpose.TOOLBAR) {
            return;
        }
        if (context.getEntities().size() != 1 || !(context.getEntity() instanceof Indi)) {
            group.add(new Goto(PARENTS));
            group.add(new Goto(SIBLINGS));
            group.add(new Goto(HUSBAND));
            group.add(new Goto(CHILDREN));
            return;
        }
        Indi indi = (Indi)context.getEntity();
        group.add(new Parents(indi));
        group.add(new Siblings(indi));
        group.add(new Spouses(indi));
        group.add(new Children(indi));
    }

    private class Children
    extends Goto {
        public Children(Indi indi) {
            super("children", Arrays.asList(indi.getChildren()), CHILDREN, -1);
        }
    }

    private class Spouses
    extends Goto {
        public Spouses(Indi indi) {
            super("spouses", Arrays.asList(indi.getPartners()), indi.getSex() == 2 ? HUSBAND : WIFE, -1);
        }
    }

    private class Siblings
    extends Goto {
        public Siblings(Indi indi) {
            super("siblings", Arrays.asList(indi.getYoungerSiblings()), Arrays.asList(indi.getOlderSiblings()), SIBLINGS, -1);
        }
    }

    private class Parents
    extends Goto {
        public Parents(Indi indi) {
            super("parents", indi.getParents(), PARENTS, 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Goto
    extends Action2 {
        protected Indi target;

        public Goto(ImageIcon imageIcon) {
            this.setImage(imageIcon);
            this.setEnabled(false);
        }

        public Goto(String string, List<Indi> list, ImageIcon imageIcon, int n) {
            this.init(string, list, imageIcon, n);
        }

        public Goto(String string, List<Indi> list, List<Indi> list2, ImageIcon imageIcon, int n) {
            list = new ArrayList<Indi>(list);
            list.addAll(list2);
            this.init(string, list, imageIcon, n);
        }

        private void init(String string, List<Indi> list, ImageIcon imageIcon, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(RES.getString("goto", RES.getString(string)));
            stringBuffer.append("<b>");
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("<br/>");
                stringBuffer.append(list.get(i));
                if (i != 0) continue;
                stringBuffer.append("</b>");
            }
            this.setTip(stringBuffer.toString());
            this.setImage(imageIcon);
            if (!list.isEmpty()) {
                this.target = list.get(0);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.target != null) {
                SelectionSink.Dispatcher.fireSelection(actionEvent, new Context(this.target));
            }
        }
    }
}

