/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionProvider {
    private static List<Option> options;

    public abstract List<? extends Option> getOptions();

    public static void persistAll() {
        for (Option option : OptionProvider.getAllOptions()) {
            try {
                option.persist();
            }
            catch (Throwable throwable) {}
        }
    }

    public static synchronized List<Option> getAllOptions() {
        if (options != null) {
            return options;
        }
        ArrayList<Option> arrayList = new ArrayList<Option>(32);
        Iterator<OptionProvider> iterator = OptionProvider.lookupProviders();
        while (iterator.hasNext()) {
            OptionProvider optionProvider = iterator.next();
            for (Option option : optionProvider.getOptions()) {
                try {
                    option.restore();
                    arrayList.add(option);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        options = arrayList;
        return options;
    }

    private static Iterator<OptionProvider> lookupProviders() {
        return ServiceRegistry.lookupProviders(OptionProvider.class);
    }
}

