/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.option.Option;
import genj.option.OptionListener;
import genj.option.OptionsWidget;
import genj.print.PrintTask;
import genj.print.ScalingWidget;
import genj.renderer.DPI;
import genj.renderer.Options;
import genj.renderer.RenderPreviewHintKey;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.ScrollPaneWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintWidget
extends JTabbedPane {
    static final Resources RESOURCES = Resources.get(PrintWidget.class);
    static final Logger LOG = Logger.getLogger("genj.print");
    private PrintTask task;
    private ChoiceWidget services;
    private ScalingWidget scaling;
    private Preview preview;
    private Apply apply = new Apply();
    private JCheckBox fit;
    private JCheckBox empties;

    public PrintWidget(PrintTask printTask) {
        this.task = printTask;
        this.add(RESOURCES.getString("printer"), this.createFirstPage());
        this.add(RESOURCES.getString("settings"), this.createSecondPage());
    }

    public void commit() {
        if (this.services.getSelectedItem() != null) {
            this.task.setService((PrintService)this.services.getSelectedItem());
        }
    }

    private JPanel createFirstPage() {
        String string = "<col><row><lprinter/><printers wx=\"1\"/><settings/></row><row><zoom/><fit/></row><row><lpreview/></row><row><preview wx=\"1\" wy=\"1\"/></row></col>";
        JPanel jPanel = new JPanel(new NestedBlockLayout(string));
        jPanel.add(new JLabel(RESOURCES.getString("printer")));
        this.services = new ChoiceWidget(this.task.getServices(), this.task.getService());
        this.services.setEditable(false);
        this.services.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    PrintWidget.this.task.setService((PrintService)PrintWidget.this.services.getSelectedItem());
                }
            }
        });
        jPanel.add(this.services);
        jPanel.add(new JButton(new Settings()));
        this.scaling = new ScalingWidget();
        this.scaling.addChangeListener(this.apply);
        jPanel.add(this.scaling);
        this.fit = new JCheckBox(RESOURCES.getString("fit"), false);
        this.fit.setEnabled(false);
        this.fit.addChangeListener(this.apply);
        jPanel.add(this.fit);
        jPanel.add(new JLabel(RESOURCES.getString("preview")));
        this.preview = new Preview();
        jPanel.add(new ScrollPaneWidget(this.preview));
        return jPanel;
    }

    private JComponent createSecondPage() {
        List<? extends Option> list = this.task.getOptions();
        for (Option option : list) {
            option.addOptionListener(this.apply);
        }
        return new OptionsWidget(this.task.getTitle(), list);
    }

    private class Apply
    implements ChangeListener,
    OptionListener {
        private Apply() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.apply();
        }

        public void optionChanged(Option option) {
            this.apply();
        }

        private void apply() {
            Object object = PrintWidget.this.scaling.getValue();
            if (object instanceof Dimension) {
                PrintWidget.this.task.setPages((Dimension)object, PrintWidget.this.fit.isSelected());
                PrintWidget.this.fit.setEnabled(true);
            }
            if (object instanceof Double) {
                PrintWidget.this.task.setZoom((Double)object);
                PrintWidget.this.fit.setEnabled(false);
            }
            PrintWidget.this.preview.revalidate();
            PrintWidget.this.preview.repaint();
        }
    }

    private class Settings
    extends Action2 {
        private Settings() {
            super.setText(RESOURCES.getString("settings"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = PrintWidget.this.getLocationOnScreen();
            PrintService printService = ServiceUI.printDialog(null, point.x, point.y, PrintWidget.this.task.getServices(), PrintWidget.this.task.getService(), null, PrintWidget.this.task.getAttributes());
            if (printService != null) {
                PrintWidget.this.services.setSelectedItem(printService);
            }
            PrintWidget.this.preview.revalidate();
            PrintWidget.this.preview.repaint();
        }
    }

    private class Preview
    extends JComponent
    implements Scrollable {
        private double zoom = 0.2;
        private int gap = 5;
        private DPI dpi = new DPI((int)((double)Options.getInstance().getDPI().horizontal() * this.zoom), (int)((double)Options.getInstance().getDPI().vertical() * this.zoom));

        private Preview() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = PrintWidget.this.task.getPages();
            Dimension2D dimension2D = this.dpi.toPixel(PrintWidget.this.task.getPageSize());
            return new Dimension((int)Math.ceil((double)dimension.width * dimension2D.getWidth() + (double)(dimension.width * this.gap) + (double)this.gap), (int)Math.ceil((double)dimension.height * dimension2D.getHeight() + (double)(dimension.height * this.gap) + (double)this.gap));
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.white);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderPreviewHintKey.KEY, true);
            graphics2D.setRenderingHint(DPI.KEY, this.dpi);
            Dimension dimension = PrintWidget.this.task.getPages();
            Dimension2D dimension2D = this.dpi.toPixel(PrintWidget.this.task.getPageSize());
            Rectangle rectangle = graphics2D.getClipBounds();
            AffineTransform affineTransform = graphics2D.getTransform();
            for (int i = 0; i < dimension.height; ++i) {
                for (int j = 0; j < dimension.width; ++j) {
                    Rectangle2D.Double double_ = new Rectangle2D.Double((double)this.gap + (double)j * (dimension2D.getWidth() + (double)this.gap), (double)this.gap + (double)i * (dimension2D.getHeight() + (double)this.gap), dimension2D.getWidth(), dimension2D.getHeight());
                    if (!rectangle.intersects(double_)) continue;
                    graphics2D.setColor(Color.white);
                    graphics2D.fill(double_);
                    graphics.setColor(Color.gray);
                    graphics.setFont(new Font("Arial", 1, 48));
                    GraphicsHelper.render(graphics2D, String.valueOf(j + i * dimension.width + 1), double_.getCenterX(), double_.getCenterY(), 0.5, 0.5);
                    graphics2D.translate((double)this.gap + (double)j * (((RectangularShape)double_).getWidth() + (double)this.gap), (double)this.gap + (double)i * (((RectangularShape)double_).getHeight() + (double)this.gap));
                    PrintWidget.this.task.print(graphics2D, i, j);
                    graphics2D.setTransform(affineTransform);
                    graphics2D.setClip(rectangle);
                }
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(0, 0);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 1 ? rectangle.height : rectangle.width;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 1;
        }
    }
}

