/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintEditor;
import genj.renderer.BlueprintManager;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ChooseBlueprintAction
extends Action2 {
    private static final Resources RESOURCES = Resources.get(ChooseBlueprintAction.class);
    private static final ImageIcon IMAGE = new ImageIcon(ChooseBlueprintAction.class, "Blueprint.png");
    private static final BlueprintManager MGR = BlueprintManager.getInstance();
    private Entity recipient;
    private Blueprint current;
    private JList blueprints;
    private BlueprintEditor editor;

    protected ChooseBlueprintAction(Entity entity, Blueprint blueprint) {
        if (entity == null) {
            throw new IllegalArgumentException("recipient==null");
        }
        this.recipient = entity;
        this.current = blueprint;
        this.setText(RESOURCES.getString("blueprint.select"));
        this.setImage(IMAGE.getOverLayed(entity.getImage(false)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.editor = new BlueprintEditor(this.recipient);
        this.blueprints = new JList<Object>(BlueprintManager.getInstance().getBlueprints(this.recipient.getTag()).toArray());
        this.blueprints.setSelectionMode(0);
        Add add = new Add();
        final Del del = new Del();
        this.blueprints.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChooseBlueprintAction.this.editor.commit();
                Blueprint blueprint = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue();
                if (blueprint == null) {
                    if (ChooseBlueprintAction.this.blueprints.getModel().getSize() > 0) {
                        ChooseBlueprintAction.this.blueprints.setSelectedIndex(listSelectionEvent.getFirstIndex());
                    } else {
                        del.setEnabled(false);
                        ChooseBlueprintAction.this.editor.set(null);
                    }
                    return;
                }
                ChooseBlueprintAction.this.editor.set(blueprint);
                del.setEnabled(!blueprint.isReadOnly());
            }
        });
        this.blueprints.setSelectedValue(this.current, true);
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><for gx=\"1\"/><row><col><row><list wy=\"1\" gx=\"1\" gy=\"1\"/></row><row><add/><del/></row></col><col><editor wy=\"1\" wx=\"1\"/></col></row></col>"));
        ButtonHelper buttonHelper = new ButtonHelper();
        jPanel.add(new JLabel(RESOURCES.getString("blueprint.select.for", Gedcom.getName(this.recipient.getTag(), true))));
        jPanel.add(new JScrollPane(this.blueprints));
        jPanel.add(buttonHelper.create(add));
        jPanel.add(buttonHelper.create(del));
        jPanel.add(this.editor);
        DialogHelper.openDialog(RESOURCES.getString("blueprint"), 3, jPanel, (Action[])Action2.okOnly(), (Object)actionEvent);
        this.editor.commit();
        this.current = (Blueprint)this.blueprints.getSelectedValue();
        if (this.current != null) {
            this.commit(this.recipient, this.current);
        }
    }

    protected abstract void commit(Entity var1, Blueprint var2);

    private class Del
    extends Action2 {
        Del() {
            super(RESOURCES.getString("blueprint.del"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Blueprint blueprint = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue();
            if (blueprint == null || blueprint.isReadOnly()) {
                return;
            }
            if (0 != DialogHelper.openDialog(null, 2, RESOURCES.getString("blueprint.del.confirm", blueprint.getName()), (Action[])Action2.okCancel(), (Object)actionEvent)) {
                return;
            }
            try {
                MGR.delBlueprint(blueprint);
            }
            catch (IOException iOException) {
                Logger.getLogger("genj.renderer").log(Level.WARNING, "can't delete blueprint " + blueprint, iOException);
            }
            ChooseBlueprintAction.this.blueprints.setListData(MGR.getBlueprints(ChooseBlueprintAction.this.recipient.getTag()).toArray());
            if (ChooseBlueprintAction.this.blueprints.getModel().getSize() > 0) {
                ChooseBlueprintAction.this.blueprints.setSelectedIndex(0);
            }
        }
    }

    private class Add
    extends Action2 {
        Add() {
            super(RESOURCES.getString("blueprint.add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Blueprint blueprint = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue();
            String string = DialogHelper.openDialog(null, 3, RESOURCES.getString("blueprint.add.confirm"), "", (Object)actionEvent);
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = blueprint != null ? blueprint.getHTML() : "";
            try {
                Blueprint blueprint2 = MGR.addBlueprint(new Blueprint(ChooseBlueprintAction.this.recipient.getTag(), string, string2, false));
                ChooseBlueprintAction.this.blueprints.setListData(MGR.getBlueprints(ChooseBlueprintAction.this.recipient.getTag()).toArray());
                ChooseBlueprintAction.this.blueprints.setSelectedValue(blueprint2, true);
            }
            catch (IOException iOException) {
                Logger.getLogger("genj.renderer").log(Level.WARNING, "can't add blueprint " + string, iOException);
            }
        }
    }
}

