/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.gedcom.Gedcom;
import genj.gedcom.UnitOfWork;
import genj.report.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

class Runner
implements Runnable {
    private static final Logger LOG = Logger.getLogger("genj.report");
    private static final long FLUSH_WAIT = 500L;
    private Gedcom gedcom;
    private Object context;
    private Report report;
    private Callback callback;
    private Object result;

    Runner(Gedcom gedcom, Object object, Report report, Callback callback) {
        this.gedcom = gedcom;
        this.context = object;
        this.report = report;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.report.setOut(new PrintWriter(new WriterImpl()));
        try {
            if (this.report.isReadOnly()) {
                this.result = this.report.start(this.context);
            } else {
                final Object object = this.context;
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        try {
                            Runner.this.result = Runner.this.report.start(object);
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable.getCause() != null) {
                throwable2 = throwable.getCause();
            }
            this.result = throwable2;
        }
        finally {
            this.report.flush();
            this.report.getOut().close();
        }
        this.callback.handleResult(this.report, this.result);
    }

    public static interface Callback {
        public void handleOutput(Report var1, String var2);

        public void handleResult(Report var1, Object var2);
    }

    private class WriterImpl
    extends Writer {
        private StringBuffer buffer = new StringBuffer(4096);
        private long lastFlush = -1L;

        private WriterImpl() {
        }

        public void close() {
            this.flush();
            LOG.log(Level.FINER, "close");
        }

        public void flush() {
            if (this.buffer.length() == 0) {
                return;
            }
            this.lastFlush = System.currentTimeMillis();
            Runner.this.callback.handleOutput(Runner.this.report, this.buffer.toString());
            this.buffer.setLength(0);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '\r') continue;
                this.buffer.append(c);
            }
            if (System.currentTimeMillis() - this.lastFlush > 500L) {
                this.flush();
            }
        }
    }
}

