/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.search.Hit;
import genj.search.Worker;
import genj.search.WorkerListener;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.ContextProvider;
import genj.view.SelectionSink;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchView
extends View {
    private static final String OPEN = "<font color=red>";
    private static final String CLOSE = "</font>";
    private static final String NEWLINE = "<br>";
    private static final String[] DEFAULT_VALUES = new String[]{"M(a|e)(i|y)er", "San.+Francisco", "^(M|F)"};
    private static final String[] DEFAULT_TAGS = new String[]{"NAME", "BIRT", "BIRT, PLAC", "OCCU", "NOTE", "BIRT, NOTE", "RESI"};
    private static final int MAX_OLD = 16;
    static final Resources RESOURCES = Resources.get(SearchView.class);
    private Context context = new Context();
    private static final Registry REGISTRY = Registry.get(SearchView.class);
    private Results results = new Results();
    private ResultWidget listResults = new ResultWidget();
    private HeadlessLabel viewFactory = new HeadlessLabel(this.listResults.getFont());
    private ChoiceWidget choiceTag;
    private ChoiceWidget choiceValue;
    private JCheckBox checkRegExp;
    private JLabel labelCount;
    private Action2 actionStart = new ActionStart();
    private Action2 actionStop = new ActionStop();
    private LinkedList<String> oldTags;
    private LinkedList<String> oldValues;
    private static final ImageIcon IMG_START = new ImageIcon(SearchView.class, "Start");
    private static final ImageIcon IMG_STOP = new ImageIcon(SearchView.class, "Stop");
    private Worker worker = new Worker((WorkerListener)Spin.over((Object)new WorkerListener(){

        @Override
        public void more(List<Hit> list) {
            SearchView.this.results.add(list);
            SearchView.this.labelCount.setText("" + SearchView.this.results.getSize());
        }

        @Override
        public void started() {
            SearchView.this.results.clear();
            SearchView.this.labelCount.setText("");
            SearchView.this.actionStart.setEnabled(false);
            SearchView.this.actionStop.setEnabled(true);
        }

        @Override
        public void stopped() {
            SearchView.this.labelCount.setText("" + SearchView.this.results.getSize());
            SearchView.this.actionStop.setEnabled(false);
            SearchView.this.actionStart.setEnabled(SearchView.this.context.getGedcom() != null);
        }
    }));

    public SearchView() {
        this.oldTags = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.tags", DEFAULT_TAGS)));
        this.oldValues = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.values", DEFAULT_VALUES)));
        boolean bl = REGISTRY.get("regexp", false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchView.this.actionStop.isEnabled()) {
                    SearchView.this.stop();
                }
                if (SearchView.this.actionStart.isEnabled()) {
                    SearchView.this.start();
                }
            }
        };
        JLabel jLabel = new JLabel(RESOURCES.getString("label.value"));
        this.checkRegExp = new JCheckBox(RESOURCES.getString("label.regexp"), bl);
        this.choiceValue = new ChoiceWidget(this.oldValues);
        this.choiceValue.addActionListener(actionListener);
        PopupWidget popupWidget = new PopupWidget("...", null);
        popupWidget.addItems(this.createPatternActions());
        popupWidget.setMargin(new Insets(0, 0, 0, 0));
        JLabel jLabel2 = new JLabel(RESOURCES.getString("label.tag"));
        this.choiceTag = new ChoiceWidget(this.oldTags);
        this.choiceTag.addActionListener(actionListener);
        PopupWidget popupWidget2 = new PopupWidget("...", null);
        popupWidget2.addItems(this.createTagActions());
        popupWidget2.setMargin(new Insets(0, 0, 0, 0));
        this.labelCount = new JLabel();
        JPanel jPanel = new JPanel();
        try {
            jPanel.setFocusCycleRoot(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GridBagHelper gridBagHelper = new GridBagHelper(jPanel);
        gridBagHelper.add(jLabel, 0, 0, 2, 1, 0, new Insets(0, 0, 0, 8));
        gridBagHelper.add(this.checkRegExp, 2, 0, 1, 1, 17);
        gridBagHelper.add(this.labelCount, 3, 0, 1, 1);
        gridBagHelper.add(popupWidget, 0, 1, 1, 1);
        gridBagHelper.add(this.choiceValue, 1, 1, 3, 1, 17, new Insets(3, 3, 3, 3));
        gridBagHelper.add(jLabel2, 0, 2, 4, 1, 17);
        gridBagHelper.add(popupWidget2, 0, 3, 1, 1);
        gridBagHelper.add(this.choiceTag, 1, 3, 3, 1, 17, new Insets(0, 3, 3, 3));
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.add("Center", new JScrollPane(this.listResults));
        this.choiceValue.requestFocusInWindow();
    }

    public void start() {
        if (this.context == null) {
            return;
        }
        this.worker.stop();
        String string = this.choiceValue.getText();
        String string2 = this.choiceTag.getText();
        this.remember(this.choiceValue, this.oldValues, string);
        this.remember(this.choiceTag, this.oldTags, string2);
        this.worker.start(this.context.getGedcom(), string2, string, this.checkRegExp.isSelected());
    }

    public void stop() {
        this.worker.stop();
    }

    @Override
    public void removeNotify() {
        REGISTRY.put("regexp", this.checkRegExp.isSelected());
        REGISTRY.put("old.values", this.oldValues);
        REGISTRY.put("old.tags", this.oldTags);
        super.removeNotify();
    }

    @Override
    public void setContext(Context context, boolean bl) {
        if (this.context.getGedcom() != null && this.context.getGedcom() != context.getGedcom()) {
            this.stop();
            this.results.clear();
            this.labelCount.setText("");
            this.actionStart.setEnabled(false);
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.results));
        }
        this.context = context;
        if (this.context.getGedcom() != null) {
            this.context = new Context(context.getGedcom());
            this.context.getGedcom().addGedcomListener((GedcomListener)Spin.over((Object)this.results));
            this.actionStart.setEnabled(true);
        }
    }

    @Override
    public void populate(ToolBar toolBar) {
        toolBar.add(this.actionStart);
        toolBar.add(this.actionStop);
    }

    private void remember(ChoiceWidget choiceWidget, LinkedList<String> linkedList, String string) {
        if (string.trim().length() == 0) {
            return;
        }
        linkedList.remove(string);
        linkedList.addFirst(string);
        if (linkedList.size() > 16) {
            linkedList.removeLast();
        }
        choiceWidget.setValues(linkedList);
        choiceWidget.setText(string);
    }

    private List<Action2> createTagActions() {
        ArrayList<Action2> arrayList = new ArrayList<Action2>();
        for (int i = 0; i < DEFAULT_TAGS.length; ++i) {
            arrayList.add(new ActionTag(DEFAULT_TAGS[i]));
        }
        return arrayList;
    }

    private List<Action2> createPatternActions() {
        ArrayList<Action2> arrayList = new ArrayList<Action2>();
        int n = 0;
        while (true) {
            String string = "regexp." + n;
            String string2 = RESOURCES.getString(string + ".txt", false);
            String string3 = RESOURCES.getString(string + ".pat", false);
            if (string2 == null) break;
            if (string3 != null) {
                arrayList.add(new ActionPattern(string2, string3));
            }
            ++n;
        }
        return arrayList;
    }

    private class ResultWidget
    extends JList
    implements ListSelectionListener,
    ListCellRenderer,
    ContextProvider {
        private JTextPane text;
        private Color[] bgColors;

        private ResultWidget() {
            super(SearchView.this.results);
            this.text = new JTextPane();
            this.bgColors = new Color[3];
            this.bgColors[0] = this.getSelectionBackground();
            this.bgColors[1] = this.getBackground();
            this.bgColors[2] = new Color(Math.max(this.bgColors[1].getRed() - 16, 0), Math.min(this.bgColors[1].getGreen() + 16, 255), Math.max(this.bgColors[1].getBlue() - 16, 0));
            this.setCellRenderer(this);
            this.addListSelectionListener(this);
            this.text.setOpaque(true);
        }

        public ViewContext getContext() {
            if (SearchView.this.context == null) {
                return null;
            }
            ArrayList<Property> arrayList = new ArrayList<Property>();
            Object[] objectArray = this.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Hit hit = (Hit)objectArray[i];
                arrayList.add(hit.getProperty());
            }
            return new ViewContext(SearchView.this.context.getGedcom(), null, (List<Property>)arrayList);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Hit hit = (Hit)object;
            int n2 = bl ? 0 : 1 + (hit.getEntity() & 1);
            this.text.setBackground(this.bgColors[n2]);
            this.text.setDocument(hit.getDocument());
            return this.text;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = SearchView.this.listResults.getSelectedIndex();
            if (n >= 0) {
                SelectionSink.Dispatcher.fireSelection(SearchView.this, new Context(SearchView.this.results.getHit(n).getProperty()), false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Results
    extends AbstractListModel
    implements GedcomListener {
        private List<Hit> hits = new ArrayList<Hit>(255);

        private Results() {
        }

        private void clear() {
            if (this.hits.isEmpty()) {
                return;
            }
            int n = this.hits.size();
            this.hits.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        private void add(List<Hit> list) {
            if (list.isEmpty()) {
                return;
            }
            int n = this.hits.size();
            this.hits.addAll(list);
            this.fireIntervalAdded(this, n, this.hits.size() - 1);
        }

        @Override
        public Object getElementAt(int n) {
            return this.hits.get(n);
        }

        @Override
        public int getSize() {
            return this.hits.size();
        }

        private Hit getHit(int n) {
            return this.hits.get(n);
        }

        @Override
        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        @Override
        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        @Override
        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
        }

        @Override
        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            for (int i = 0; i < this.hits.size(); ++i) {
                Hit hit = this.hits.get(i);
                if (hit.getProperty() != property) continue;
                this.fireContentsChanged(this, i, i);
            }
        }

        @Override
        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            int n2 = 0;
            while (n2 < this.hits.size()) {
                Hit hit = this.hits.get(n2);
                if (hit.getProperty() == property2) {
                    this.hits.remove(n2);
                    this.fireIntervalRemoved(this, n2, n2);
                    continue;
                }
                ++n2;
            }
        }
    }

    private class ActionStop
    extends Action2 {
        private ActionStop() {
            this.setImage(IMG_STOP);
            this.setTip(RESOURCES.getString("stop.tip"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchView.this.stop();
        }
    }

    private class ActionStart
    extends Action2 {
        private ActionStart() {
            this.setImage(IMG_START);
            this.setTip(RESOURCES.getString("start.tip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchView.this.stop();
            SearchView.this.start();
        }
    }

    private class ActionPattern
    extends Action2 {
        private String pattern;

        private ActionPattern(String string, String string2) {
            int n = string.indexOf(32);
            if (n > 0) {
                string = "<html><b>" + string.substring(0, n) + "</b>&nbsp;&nbsp;&nbsp;" + string.substring(n) + "</html>";
            }
            this.setText(string);
            this.pattern = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final JTextField jTextField = SearchView.this.choiceValue.getTextEditor();
            int n = jTextField.getSelectionStart();
            int n2 = jTextField.getSelectionEnd();
            if (n2 <= n) {
                n2 = n = jTextField.getCaretPosition();
            }
            String string = jTextField.getText();
            String string2 = string.substring(0, n);
            String string3 = n2 > n ? '(' + string.substring(n, n2) + ')' : "";
            String string4 = string.substring(n2);
            final String string5 = MessageFormat.format(this.pattern, string, string2, string3, string4);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = string5.indexOf(35);
                    jTextField.setText(string5.substring(0, n) + string5.substring(n + 1));
                    jTextField.select(0, 0);
                    jTextField.setCaretPosition(n);
                    SearchView.this.checkRegExp.setSelected(true);
                }
            });
        }
    }

    private class ActionTag
    extends Action2 {
        private String tags;

        private ActionTag(String string) {
            this.tags = string;
            WordBuffer wordBuffer = new WordBuffer(", ");
            for (String string2 : string.split(",")) {
                wordBuffer.append(Gedcom.getName(string2.trim()));
            }
            this.setText(wordBuffer.toString());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchView.this.choiceTag.setText(this.tags);
        }
    }
}

