/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.table.TableViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.view.SettingsAction;
import genj.view.ToolBar;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public class TableView
extends View {
    private static final Logger LOG = Logger.getLogger("genj.table");
    private static final Registry REGISTRY = Registry.get(TableView.class);
    private Resources resources = Resources.get(this);
    PropertyTableWidget propertyTable;
    private Map<String, Mode> modes = new HashMap<String, Mode>();
    private Mode currentMode;

    public TableView() {
        this.modes.put("INDI", new Mode("INDI", new String[]{"INDI", "INDI:NAME", "INDI:SEX", "INDI:BIRT:DATE", "INDI:BIRT:PLAC", "INDI:OCCU", "INDI:FAMS", "INDI:FAMC"}));
        this.modes.put("FAM", new Mode("FAM", new String[]{"FAM", "FAM:MARR:DATE", "FAM:MARR:PLAC", "FAM:HUSB", "FAM:WIFE", "FAM:CHIL"}));
        this.modes.put("OBJE", new Mode("OBJE", new String[]{"OBJE", "OBJE:FILE:TITL"}));
        this.modes.put("NOTE", new Mode("NOTE", new String[]{"NOTE", "NOTE:NOTE"}));
        this.modes.put("SOUR", new Mode("SOUR", new String[]{"SOUR", "SOUR:TITL", "SOUR:TEXT"}));
        this.modes.put("SUBM", new Mode("SUBM", new String[]{"SUBM", "SUBM:NAME"}));
        this.modes.put("REPO", new Mode("REPO", new String[]{"REPO", "REPO:NAME", "REPO:NOTE"}));
        for (Mode mode : this.modes.values()) {
            mode.load();
        }
        this.propertyTable = new PropertyTableWidget();
        this.propertyTable.setAutoResize(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertyTable, "Center");
        this.currentMode = this.getMode("INDI");
        String string = REGISTRY.get("mode", "");
        if (this.modes.containsKey(string)) {
            this.currentMode = this.getMode(string);
        }
        new NextMode(true).install(this, "ctrl pressed LEFT");
        new NextMode(false).install(this, "ctrl pressed RIGHT");
    }

    public Gedcom getGedcom() {
        PropertyTableModel propertyTableModel = this.propertyTable.getModel();
        return propertyTableModel != null ? propertyTableModel.getGedcom() : null;
    }

    PropertyTableWidget getTable() {
        return this.propertyTable;
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 320);
    }

    Mode getMode() {
        return this.currentMode;
    }

    Mode getMode(String string) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            mode = new Mode(string, new String[0]);
            this.modes.put(string, mode);
        }
        return mode;
    }

    void setMode(Mode mode) {
        REGISTRY.put("mode", mode.getTag());
        PropertyTableModel propertyTableModel = this.propertyTable.getModel();
        if (propertyTableModel != null && this.currentMode != null) {
            this.currentMode.save();
        }
        this.currentMode = mode;
        if (propertyTableModel != null) {
            this.propertyTable.setModel(new Model(propertyTableModel.getGedcom(), this.currentMode));
            this.propertyTable.setColumnLayout(this.currentMode.layout);
        }
    }

    public void setContext(Context context, boolean bl) {
        Mode mode;
        this.currentMode.save();
        PropertyTableModel propertyTableModel = this.propertyTable.getModel();
        if (context.getGedcom() == null) {
            if (propertyTableModel != null) {
                this.propertyTable.setModel(null);
            }
            return;
        }
        if (propertyTableModel == null || propertyTableModel.getGedcom() != context.getGedcom()) {
            this.propertyTable.setModel(new Model(context.getGedcom(), this.currentMode));
            this.propertyTable.setColumnLayout(this.currentMode.layout);
        }
        if ((mode = this.getModeFor(context)) != this.currentMode) {
            mode.setSelected(true);
        }
        this.propertyTable.select(context);
    }

    private Mode getModeFor(Context context) {
        for (Entity entity : context.getEntities()) {
            if (!this.currentMode.tag.equals(entity.getTag())) continue;
            return this.currentMode;
        }
        for (Entity entity : context.getEntities()) {
            Mode mode = this.modes.get(entity.getTag());
            if (mode == null) continue;
            return mode;
        }
        return this.currentMode;
    }

    public void populate(ToolBar toolBar) {
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = true;
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            String string = Gedcom.ENTITIES[i];
            Mode mode = this.getMode(string);
            JToggleButton jToggleButton = new JToggleButton(mode);
            toolBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (this.currentMode != mode) continue;
            mode.setSelected(true);
        }
        toolBar.add(new Settings());
    }

    public void removeNotify() {
        for (Mode mode : this.modes.values()) {
            mode.save();
        }
        super.removeNotify();
    }

    class Mode
    extends Action2 {
        private String tag;
        private String[] defaults;
        private TagPath[] paths;
        private String layout;

        private Mode(String string, String[] stringArray) {
            this.tag = string;
            this.defaults = stringArray;
            this.paths = TagPath.toArray(this.defaults);
            this.setTip(TableView.this.resources.getString("mode.tip", Gedcom.getName(this.tag, true)));
            this.setImage(Gedcom.getEntityImage(this.tag));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(true);
        }

        public boolean setSelected(boolean bl) {
            if (bl) {
                TableView.this.setMode(this);
            }
            return super.setSelected(bl);
        }

        private void load() {
            String[] stringArray = REGISTRY.get(this.tag + ".paths", (String[])null);
            if (stringArray != null) {
                this.paths = TagPath.toArray(stringArray);
            }
            this.layout = REGISTRY.get(this.tag + ".layout", (String)null);
        }

        void setPaths(TagPath[] tagPathArray) {
            this.paths = tagPathArray;
            if (TableView.this.currentMode == this) {
                TableView.this.setMode(TableView.this.currentMode);
            }
        }

        TagPath[] getPaths() {
            return this.paths;
        }

        private void save() {
            if (TableView.this.currentMode == this && TableView.this.propertyTable.getModel() != null) {
                this.layout = TableView.this.propertyTable.getColumnLayout();
            }
            REGISTRY.put(this.tag + ".paths", this.paths);
            REGISTRY.put(this.tag + ".layout", this.layout);
        }

        String getTag() {
            return this.tag;
        }
    }

    private class Model
    extends AbstractPropertyTableModel {
        private Mode mode;
        private List<Entity> rows;

        private Model(Gedcom gedcom, Mode mode) {
            super(gedcom);
            this.mode = mode;
        }

        public int getNumCols() {
            return this.mode.getPaths().length;
        }

        public int getNumRows() {
            if (this.rows == null) {
                this.rows = new ArrayList<Entity>(super.getGedcom().getEntities(this.mode.getTag()));
            }
            return this.rows.size();
        }

        public TagPath getColPath(int n) {
            return this.mode.getPaths()[n];
        }

        public Property getRowRoot(int n) {
            this.getNumRows();
            Property property = this.rows.get(n);
            if (property == null) {
                return property;
            }
            if (property.getEntity() == null) {
                property = null;
                this.rows.set(n, null);
            }
            return property;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            this.rows.add(entity);
            this.fireRowsAdded(this.rows.size() - 1, this.rows.size() - 1);
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                if (this.rows.get(i) != entity) continue;
                this.rows.remove(i);
                this.fireRowsDeleted(i, i);
                return;
            }
            LOG.warning("got notified that entity " + entity.getId() + " was deleted but it wasn't in rows in the first place");
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
            this.invalidate(gedcom, property.getEntity(), property2.getPath());
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.invalidate(gedcom, property.getEntity(), property.getPath());
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            this.invalidate(gedcom, property.getEntity(), new TagPath(property.getPath(), property2.getTag()));
        }

        private void invalidate(Gedcom gedcom, Entity entity, TagPath tagPath) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            TagPath[] tagPathArray = this.mode.getPaths();
            for (int i = 0; i < tagPathArray.length; ++i) {
                if (!tagPathArray[i].equals(tagPath)) continue;
                for (int j = 0; j < this.rows.size(); ++j) {
                    if (this.rows.get(j) != entity) continue;
                    this.fireRowsChanged(j, j, i);
                    return;
                }
            }
        }
    }

    private class NextMode
    extends Action2 {
        private int dir;

        private NextMode(boolean bl) {
            this.dir = bl ? -1 : 1;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            int n2 = Gedcom.ENTITIES.length;
            for (int i = 0; i < n2; ++i) {
                n = (i + n2 + this.dir) % Gedcom.ENTITIES.length;
                if (TableView.this.currentMode == TableView.this.getMode(Gedcom.ENTITIES[i])) break;
            }
            TableView.this.getMode(Gedcom.ENTITIES[n]).setSelected(true);
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TableViewSettings getEditor() {
            return new TableViewSettings(TableView.this);
        }
    }
}

