/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import genj.common.PathTreeWidget;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.table.TableView;
import genj.util.GridBagHelper;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableViewSettings
extends JPanel {
    private PathTreeWidget pathTree;
    private ListSelectionWidget<TagPath> pathList;
    private Resources resources = Resources.get(this);

    public TableViewSettings(final TableView tableView) {
        final Grammar grammar = tableView.getGedcom() != null ? tableView.getGedcom().getGrammar() : Grammar.V55;
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        this.pathTree = new PathTreeWidget();
        PathTreeWidget.Listener listener = new PathTreeWidget.Listener(){

            public void handleSelection(TagPath tagPath, boolean bl) {
                if (!bl) {
                    TableViewSettings.this.pathList.removeChoice(tagPath);
                } else {
                    TableViewSettings.this.pathList.addChoice(tagPath);
                }
            }
        };
        String string = tableView.getMode().getTag();
        TagPath[] tagPathArray = tableView.getMode(string).getPaths();
        TagPath[] tagPathArray2 = grammar.getAllPaths(string, Property.class);
        this.pathTree.setGrammar(grammar);
        this.pathTree.setPaths(tagPathArray2, tagPathArray);
        this.pathTree.addListener(listener);
        final Move move = new Move(true);
        final Move move2 = new Move(false);
        final Del del = new Del();
        this.pathList = new ListSelectionWidget<TagPath>(){

            @Override
            protected ImageIcon getIcon(TagPath tagPath) {
                return grammar.getMeta(tagPath).getImage();
            }
        };
        this.pathList.setChoices((TagPath[])tagPathArray);
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TagPath tagPath = (TagPath)TableViewSettings.this.pathList.getChoice(mouseEvent.getPoint());
                if (tagPath != null && mouseEvent.getClickCount() == 2) {
                    TableViewSettings.this.pathTree.setSelected(tagPath, false);
                }
            }
        });
        this.pathList.addSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableViewSettings.this.pathList.getSelectedIndex();
                move.setEnabled(n > 0);
                move2.setEnabled(n >= 0 && n < TableViewSettings.this.pathList.getChoices().size() - 1);
                del.setEnabled(n >= 0);
            }
        });
        this.pathList.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                List<TagPath> list = TableViewSettings.this.pathList.getChoices();
                tableView.getMode().setPaths(list.toArray(new TagPath[list.size()]));
            }
        });
        gridBagHelper.add(new JLabel(this.resources.getString("info.columns")), 0, 0, 4, 1, 1);
        gridBagHelper.add(this.pathTree, 0, 1, 4, 1, 68);
        gridBagHelper.add(new JLabel(this.resources.getString("info.order")), 0, 2, 4, 1, 1);
        gridBagHelper.add(this.pathList, 0, 3, 4, 1, 68);
        gridBagHelper.add(new JButton(move), 0, 4, 1, 1, 1);
        gridBagHelper.add(new JButton(move2), 1, 4, 1, 1, 1);
        gridBagHelper.add(new JButton(del), 2, 4, 1, 1, 1);
    }

    private class Del
    extends Action2 {
        protected Del() {
            this.setEnabled(false);
            this.setText(TableViewSettings.this.resources, "info.del");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableViewSettings.this.pathTree.setSelected((TagPath)TableViewSettings.this.pathList.getSelectedChoice(), false);
        }
    }

    private class Move
    extends Action2 {
        private boolean up;

        protected Move(boolean bl) {
            this.up = bl;
            this.setEnabled(false);
            if (bl) {
                this.setText(TableViewSettings.this.resources, "info.up");
            } else {
                this.setText(TableViewSettings.this.resources, "info.down");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TableViewSettings.this.pathList.getSelectedIndex();
            if (this.up) {
                TableViewSettings.this.pathList.swapChoices(n, n - 1);
            } else {
                TableViewSettings.this.pathList.swapChoices(n, n + 1);
            }
        }
    }
}

