/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Gedcom;
import genj.gedcom.PropertyDate;
import genj.renderer.Options;
import genj.timeline.Model;
import genj.util.swing.ImageIcon;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContentRenderer {
    protected Point2D.Double dotSize = new Point2D.Double();
    protected GeneralPath fromMark;
    protected GeneralPath toMark;
    protected Shape atMark;
    boolean paintTags = false;
    boolean paintDates = true;
    boolean paintGrid = false;
    Set<Model.Event> selection = new HashSet<Model.Event>();
    Color cBackground = null;
    Color cText = null;
    Color cTag = null;
    Color cDate = null;
    Color cTimespan = null;
    Color cGrid = null;
    Color cSelected = null;

    public void render(UnitGraphics unitGraphics, Model model) {
        this.init(unitGraphics);
        this.renderBackground(unitGraphics, model);
        this.renderGrid(unitGraphics, model);
        this.renderLayers(unitGraphics, model);
    }

    protected void renderBackground(UnitGraphics unitGraphics, Model model) {
        if (this.cBackground == null) {
            return;
        }
        unitGraphics.setColor(this.cBackground);
        Rectangle2D.Double double_ = new Rectangle2D.Double(model.min, 0.0, model.max - model.min, 1024.0);
        unitGraphics.draw(double_, 0.0, 0.0, true);
    }

    private final void renderGrid(UnitGraphics unitGraphics, Model model) {
        if (!this.paintGrid) {
            return;
        }
        unitGraphics.setColor(this.cGrid);
        Rectangle2D rectangle2D = unitGraphics.getClip();
        int n = model.layers.size();
        double d = Math.floor(rectangle2D.getMinX());
        double d2 = Math.ceil(rectangle2D.getMaxX());
        for (double d3 = d; d3 <= d2; d3 += 1.0) {
            unitGraphics.draw(d3, 0.0, d3, n);
        }
    }

    private final void renderLayers(UnitGraphics unitGraphics, Model model) {
        Rectangle2D rectangle2D = unitGraphics.getClip();
        List<List<Model.Event>> list = model.layers;
        for (int i = 0; i < list.size(); ++i) {
            if ((double)i < Math.floor(rectangle2D.getMinY()) || (double)i > Math.ceil(rectangle2D.getMaxY())) continue;
            List<Model.Event> list2 = list.get(i);
            this.renderEvents(unitGraphics, model, list2, i);
        }
    }

    private final void renderEvents(UnitGraphics unitGraphics, Model model, List list, int n) {
        Rectangle2D rectangle2D = unitGraphics.getClip();
        Iterator iterator = list.iterator();
        Model.Event event = (Model.Event)iterator.next();
        while (true) {
            Model.Event event2;
            Model.Event event3 = event2 = iterator.hasNext() ? (Model.Event)iterator.next() : null;
            if ((event2 == null || event2.from > rectangle2D.getMinX()) && event.from < rectangle2D.getMaxX()) {
                this.renderEvent(unitGraphics, model, event, event2, n);
            }
            if (event2 == null) break;
            event = event2;
        }
    }

    private final void renderEvent(UnitGraphics unitGraphics, Model model, Model.Event event, Model.Event event2, int n) {
        Object object;
        boolean bl = this.selection.contains(event);
        FontMetrics fontMetrics = unitGraphics.getFontMetrics();
        unitGraphics.setColor(this.cTimespan);
        PropertyDate.Format format = event.pd.getFormat();
        if (format == PropertyDate.AFTER || format == PropertyDate.FROM) {
            unitGraphics.draw(this.fromMark, event.from, (double)(n + 1), true);
        } else if (format == PropertyDate.BEFORE || format == PropertyDate.TO) {
            unitGraphics.draw(this.toMark, event.from, (double)(n + 1), true);
        } else if (event.from == event.to) {
            unitGraphics.draw(this.atMark, event.from, (double)(n + 1), false);
        } else {
            unitGraphics.draw(this.fromMark, event.from, (double)(n + 1), true);
            unitGraphics.draw(event.from, (double)(n + 1) - this.dotSize.y, event.to, (double)(n + 1) - this.dotSize.y);
            unitGraphics.draw(this.toMark, event.to, (double)(n + 1), true);
        }
        unitGraphics.pushClip(event.from, n, event2 == null ? 2.147483647E9 : event2.from, n + 1);
        int n2 = 0;
        if (!this.paintTags) {
            object = event.pe.getImage(false);
            unitGraphics.draw((ImageIcon)object, event.from, (double)n + 0.5, 0.0, 0.5);
            n2 += ((javax.swing.ImageIcon)object).getIconWidth() + 2;
        }
        if (this.paintTags) {
            object = Gedcom.getName(event.pe.getTag());
            unitGraphics.setColor(this.cTag);
            unitGraphics.draw((String)object, event.from, n + 1, 0.0, 1.0, n2, 0);
            n2 += fontMetrics.stringWidth((String)object) + fontMetrics.charWidth(' ');
        }
        unitGraphics.setFont(Options.getInstance().getDefaultFont());
        unitGraphics.setColor(bl ? this.cSelected : this.cText);
        object = event.content;
        unitGraphics.draw((String)object, event.from, n + 1, 0.0, 1.0, n2, 0);
        n2 += fontMetrics.stringWidth((String)object) + fontMetrics.charWidth(' ');
        if (this.paintDates) {
            String string = " (" + event.pd.getDisplayValue() + ')';
            unitGraphics.setColor(this.cDate);
            unitGraphics.draw(string, event.from, n + 1, 0.0, 1.0, n2, 0);
        }
        unitGraphics.popClip();
    }

    protected void init(UnitGraphics unitGraphics) {
        this.dotSize.setLocation(1.0 / unitGraphics.getUnit().getX(), 1.0 / unitGraphics.getUnit().getY());
        this.fromMark = new GeneralPath();
        this.fromMark.moveTo((float)(3.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(-5.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(3.0 * this.dotSize.y));
        this.fromMark.closePath();
        this.toMark = new GeneralPath();
        this.toMark.moveTo((float)(-3.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(-6.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(4.0 * this.dotSize.y));
        this.toMark.closePath();
        this.atMark = new Rectangle2D.Double(-1.0 * this.dotSize.x, -1.0 * this.dotSize.y, 2.0 * this.dotSize.x, 2.0 * this.dotSize.y);
    }
}

