/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.timeline.ContentRenderer;
import genj.timeline.Model;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class RulerRenderer
extends ContentRenderer {
    Color cTick = null;
    private Shape tickMark;
    private Shape eventMark;

    public void render(UnitGraphics unitGraphics, Model model) {
        this.init(unitGraphics);
        FontMetrics fontMetrics = unitGraphics.getFontMetrics();
        double d = Math.ceil(model.min);
        double d2 = Math.floor(model.max);
        double d3 = (double)fontMetrics.stringWidth(" 0000 ") * this.dotSize.x;
        this.renderBackground(unitGraphics, model);
        this.renderYear(unitGraphics, model, fontMetrics, d, 0.0);
        this.renderYear(unitGraphics, model, fontMetrics, d2, 1.0);
        this.renderSpan(unitGraphics, model, fontMetrics, d += d3, d2 += -d3, d3);
    }

    private void renderSpan(UnitGraphics unitGraphics, Model model, FontMetrics fontMetrics, double d, double d2, double d3) {
        if (d2 - d < d3 || d2 - d < 1.0) {
            return;
        }
        Rectangle2D rectangle2D = unitGraphics.getClip();
        if (!rectangle2D.intersects(d, 0.0, d2 - d, 1.0)) {
            return;
        }
        double d4 = Math.rint((d + d2) / 2.0);
        if (d4 - d < d3 / 2.0 || d2 - d4 < d3 / 2.0) {
            return;
        }
        this.renderYear(unitGraphics, model, fontMetrics, d4, 0.5);
        this.renderSpan(unitGraphics, model, fontMetrics, d4 + d3 / 2.0, d2, d3);
        this.renderSpan(unitGraphics, model, fontMetrics, d, d4 - d3 / 2.0, d3);
    }

    private void renderYear(UnitGraphics unitGraphics, Model model, FontMetrics fontMetrics, double d, double d2) {
        unitGraphics.setColor(this.cTick);
        unitGraphics.draw(this.tickMark, d, 1.0, true);
        unitGraphics.setColor(this.cText);
        unitGraphics.draw(Integer.toString((int)d), d, 1.0, d2, 1.0);
    }

    protected void init(UnitGraphics unitGraphics) {
        super.init(unitGraphics);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(0.0 * this.dotSize.x), (float)(0.0 * this.dotSize.y));
        generalPath.lineTo((float)(3.0 * this.dotSize.x), (float)(-3.0 * this.dotSize.y));
        generalPath.lineTo((float)(-3.0 * this.dotSize.x), (float)(-3.0 * this.dotSize.y));
        generalPath.closePath();
        this.tickMark = generalPath;
        this.eventMark = new Line2D.Double(0.0, 0.0, 0.0, 5.0 * this.dotSize.y);
    }
}

