/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.renderer.DPI;
import genj.util.Dimension2d;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageSniffer {
    private String suffix = null;
    private int read = 0;
    protected Dimension dimension;
    protected DPI dpi = new DPI(72, 72);

    public ImageSniffer(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.init(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImageSniffer(InputStream inputStream) {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) {
        try {
            int n = (this.read(inputStream) & 0xFF) << 8 | this.read(inputStream) & 0xFF;
            switch (n) {
                case 18249: {
                    this.sniffGif(inputStream);
                    break;
                }
                case 35152: {
                    this.sniffPng(inputStream);
                    break;
                }
                case 65496: {
                    this.sniffJpg(inputStream);
                    break;
                }
                case 16973: {
                    this.sniffBmp(inputStream);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.dpi != null && (this.dpi.horizontal() <= 0 || this.dpi.vertical() <= 0)) {
            this.dpi = null;
        }
        if (this.dimension != null && (this.dimension.width < 1 || this.dimension.height < 1)) {
            this.dimension = null;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public DPI getDPI() {
        return this.dpi;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Dimension2D getDimensionInInches() {
        if (this.dpi == null || this.dimension == null) {
            return null;
        }
        return new Dimension2d((double)this.dimension.width / (double)this.dpi.horizontal(), (double)this.dimension.height / (double)this.dpi.vertical());
    }

    private void sniffGif(InputStream inputStream) throws IOException {
        int n = this.string2int("F89a");
        int n2 = this.string2int("F87a");
        int n3 = this.sniffIntBigEndian(inputStream);
        if (n3 != n && n3 != n2) {
            return;
        }
        this.dimension = new Dimension(this.sniffShortLittleEndian(inputStream), this.sniffShortLittleEndian(inputStream));
        this.suffix = "gif";
    }

    private void sniffPng(InputStream inputStream) throws IOException {
        int n = this.string2int("IHDR");
        int n2 = this.string2int("IDAT");
        int n3 = this.string2int("IEND");
        int n4 = this.string2int("pHYs");
        if (!this.sniff(inputStream, new byte[]{78, 71, 13, 10, 26, 10})) {
            return;
        }
        int n5 = this.sniffIntBigEndian(inputStream);
        int n6 = this.sniffIntBigEndian(inputStream);
        if (n != n6) {
            return;
        }
        this.dimension = new Dimension(this.sniffIntBigEndian(inputStream), this.sniffIntBigEndian(inputStream));
        this.skip(n5 - 8 + 4, inputStream);
        while (true) {
            n5 = this.sniffIntBigEndian(inputStream);
            n6 = this.sniffIntBigEndian(inputStream);
            if (n2 == n6 || n3 == n6) break;
            if (n4 == n6) {
                int n7 = this.sniffIntBigEndian(inputStream);
                int n8 = this.sniffIntBigEndian(inputStream);
                if (this.read(inputStream) != 1) break;
                this.dpi = new DPI((int)Math.round(2.54 * (double)n7 / 100.0), (int)Math.round(2.54 * (double)n8 / 100.0));
                break;
            }
            this.skip(n5 + 4, inputStream);
        }
        this.suffix = "png";
    }

    private boolean sniffTiff(InputStream inputStream) throws IOException {
        boolean bl;
        int n = this.read;
        switch (this.sniffShortLittleEndian(inputStream)) {
            case 18761: {
                bl = true;
                break;
            }
            case 19789: {
                bl = false;
                break;
            }
            default: {
                return false;
            }
        }
        this.skip(2, inputStream);
        this.skip(this.sniffInt(inputStream, bl) - (this.read - n), inputStream);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.sniffShort(inputStream, bl);
        block8: for (int i = 0; i < n4; ++i) {
            int n5 = this.sniffShort(inputStream, bl);
            int n6 = this.sniffShort(inputStream, bl);
            int n7 = this.sniffInt(inputStream, bl);
            int n8 = this.sniffInt(inputStream, bl);
            switch (n5) {
                case 282: {
                    n2 = n8;
                    continue block8;
                }
                case 283: {
                    n3 = n8;
                }
            }
        }
        if (n2 < this.read - n || n3 < this.read - n) {
            return false;
        }
        if (n2 < n3) {
            this.skip(n2 - (this.read - n), inputStream);
            n2 = this.sniffInt(inputStream, bl) / this.sniffInt(inputStream, bl);
            this.skip(n3 - (this.read - n), inputStream);
            n3 = this.sniffInt(inputStream, bl) / this.sniffInt(inputStream, bl);
        } else {
            this.skip(n3 - (this.read - n), inputStream);
            n3 = this.sniffInt(inputStream, bl) / this.sniffInt(inputStream, bl);
            this.skip(n2 - (this.read - n), inputStream);
            n2 = this.sniffInt(inputStream, bl) / this.sniffInt(inputStream, bl);
        }
        this.dpi = new DPI(n2, n3);
        return true;
    }

    private void sniffJpg(InputStream inputStream) throws IOException {
        byte[] byArray = "JFIF".getBytes();
        byte[] byArray2 = "Exif".getBytes();
        block10: while (true) {
            int n = this.sniffShortBigEndian(inputStream);
            int n2 = this.sniffShortBigEndian(inputStream) - 2;
            int n3 = this.read;
            switch (n) {
                case 65505: {
                    if (!this.sniff(inputStream, byArray2)) break;
                    this.skip(2, inputStream);
                    this.sniffTiff(inputStream);
                    break;
                }
                case 65504: {
                    if (!this.sniff(inputStream, byArray)) break;
                    this.skip(3, inputStream);
                    switch (this.read(inputStream)) {
                        case 1: {
                            this.dpi = new DPI(this.sniffShortBigEndian(inputStream), this.sniffShortBigEndian(inputStream));
                            break;
                        }
                        case 2: {
                            this.dpi = new DPI((int)((float)this.sniffShortBigEndian(inputStream) * 2.54f), (int)((float)this.sniffShortBigEndian(inputStream) * 2.54f));
                        }
                    }
                    break;
                }
                case 65472: 
                case 65473: 
                case 65474: 
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: 
                case 65481: 
                case 65482: 
                case 65483: 
                case 65484: 
                case 65485: 
                case 65486: 
                case 65487: {
                    this.read(inputStream);
                    this.dimension = new Dimension(this.sniffShortBigEndian(inputStream), this.sniffShortBigEndian(inputStream));
                    this.read(inputStream);
                    break;
                }
                case 65497: {
                    break block10;
                }
                default: {
                    if ((n & 0xFF00) == 65280) break;
                    return;
                }
            }
            this.skip(n2 - (this.read - n3), inputStream);
        }
        this.suffix = "jpg";
    }

    private void sniffBmp(InputStream inputStream) throws IOException {
        this.skip(16, inputStream);
        this.dimension = new Dimension(this.sniffIntLittleEndian(inputStream), this.sniffIntLittleEndian(inputStream));
        this.skip(2, inputStream);
        int n = this.sniffShortLittleEndian(inputStream);
        if (n != 1 && n != 4 && n != 8 && n != 16 && n != 24 && n != 32) {
            return;
        }
        this.skip(8, inputStream);
        this.dpi = new DPI((int)Math.round(2.54 * (double)this.sniffIntLittleEndian(inputStream) / 100.0), (int)Math.round(2.54 * (double)this.sniffIntLittleEndian(inputStream) / 100.0));
        this.suffix = "bmp";
    }

    private int read(InputStream inputStream) throws IOException {
        ++this.read;
        return inputStream.read();
    }

    private void skip(int n, InputStream inputStream) throws IOException {
        this.read += n;
        if ((long)n != inputStream.skip(n)) {
            throw new IOException("cannot skip");
        }
    }

    private boolean sniff(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n = this.read(inputStream);
            if (n != -1 && n == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private boolean sniff(InputStream inputStream, String string) throws IOException {
        return this.sniff(inputStream, string.getBytes());
    }

    private int sniffInt(InputStream inputStream, boolean bl) throws IOException {
        return bl ? this.sniffIntLittleEndian(inputStream) : this.sniffIntBigEndian(inputStream);
    }

    private int sniffIntBigEndian(InputStream inputStream) throws IOException {
        return (this.read(inputStream) & 0xFF) << 24 | (this.read(inputStream) & 0xFF) << 16 | (this.read(inputStream) & 0xFF) << 8 | this.read(inputStream) & 0xFF;
    }

    private int sniffIntLittleEndian(InputStream inputStream) throws IOException {
        return this.read(inputStream) & 0xFF | (this.read(inputStream) & 0xFF) << 8 | (this.read(inputStream) & 0xFF) << 16 | (this.read(inputStream) & 0xFF) << 24;
    }

    private int sniffShort(InputStream inputStream, boolean bl) throws IOException {
        return bl ? this.sniffShortLittleEndian(inputStream) : this.sniffShortBigEndian(inputStream);
    }

    private int sniffShortBigEndian(InputStream inputStream) throws IOException {
        return (this.read(inputStream) & 0xFF) << 8 | this.read(inputStream) & 0xFF;
    }

    private int sniffShortLittleEndian(InputStream inputStream) throws IOException {
        return this.read(inputStream) & 0xFF | (this.read(inputStream) & 0xFF) << 8;
    }

    private int string2int(String string) {
        if (string.length() != 4) {
            throw new IllegalArgumentException();
        }
        return (string.charAt(0) & 0xFF) << 24 | (string.charAt(1) & 0xFF) << 16 | (string.charAt(2) & 0xFF) << 8 | string.charAt(3) & 0xFF;
    }
}

