/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class Origin {
    private static Logger LOG = Logger.getLogger("genj.util");
    private static final char BSLASH = '\\';
    private static final char FSLASH = '/';
    private static final char COLON = ':';
    protected URL url;
    private static final Pattern ABSOLUTE = Pattern.compile("([a-z]:).*|([A-Z]:).*|\\/.*|\\\\.*");

    protected Origin(URL uRL) {
        this.url = uRL;
    }

    public static Origin create(String string) throws MalformedURLException {
        return Origin.create(new URL(string));
    }

    public static Origin create(URL uRL) {
        if (uRL.getFile().endsWith(".zip")) {
            return new ZipOrigin(uRL);
        }
        return new DefaultOrigin(uRL);
    }

    public abstract InputStream open() throws IOException;

    public final InputStream open(String string) throws IOException {
        if (ABSOLUTE.matcher(string = this.back2forwardslash(string)).matches()) {
            URLConnection uRLConnection;
            LOG.finer("Trying to open " + string + " as absolute path (origin is " + this + ")");
            try {
                uRLConnection = new URL(string).openConnection();
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRLConnection = new URL("file:" + string).openConnection();
                }
                catch (MalformedURLException malformedURLException2) {
                    return null;
                }
            }
            return new InputStreamImpl(uRLConnection.getInputStream(), uRLConnection.getContentLength());
        }
        LOG.finer("Trying to open " + string + " as relative path (origin is " + this + ")");
        return this.openImpl(string);
    }

    protected abstract InputStream openImpl(String var1) throws IOException;

    public String toString() {
        return this.url.toString();
    }

    public String calcRelativeLocation(String string) {
        String string2 = this.url.toString();
        if (string2.startsWith("file://")) {
            string2 = string2.substring("file:/".length());
        } else if (string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
        }
        if (!ABSOLUTE.matcher(string).matches()) {
            return null;
        }
        try {
            string2 = this.back2forwardslash(new File(string2.substring(0, string2.lastIndexOf(47))).getCanonicalPath()) + "/";
            string = this.back2forwardslash(new File(string).getCanonicalPath());
            boolean bl = string.startsWith(string2);
            LOG.finer("File " + string + " is " + (bl ? "" : "not ") + "relative to " + string2);
            if (bl) {
                return string.substring(string2.length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public abstract String[] list() throws IOException;

    public abstract File getFile();

    public abstract File getFile(String var1);

    public String getFileName() {
        return this.getName();
    }

    public String getName() {
        String string = this.back2forwardslash(this.url.toString());
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public boolean equals(Object object) {
        return object instanceof Origin && ((Origin)object).url.toString().equals(this.url.toString());
    }

    public int hashCode() {
        return this.url.toString().hashCode();
    }

    protected String back2forwardslash(String string) {
        return string.toString().replace('\\', '/');
    }

    private static class InputStreamImpl
    extends InputStream {
        private InputStream in;
        private int available;

        protected InputStreamImpl(InputStream inputStream, int n) {
            this.in = inputStream;
            this.available = n;
        }

        public int read() throws IOException {
            if (this.available > 0) {
                --this.available;
            }
            return this.in.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.available = Math.max(0, this.available - n2);
            return this.in.read(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.available;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class ZipOrigin
    extends Origin {
        private byte[] cachedBits;

        protected ZipOrigin(URL uRL) {
            super(uRL);
        }

        public String[] list() throws IOException {
            ZipEntry zipEntry;
            ArrayList<String> arrayList = new ArrayList<String>();
            ZipInputStream zipInputStream = this.openImpl();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                arrayList.add(zipEntry.getName());
            }
            zipInputStream.close();
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public InputStream open() throws IOException {
            String string = this.url.getRef();
            if (string == null || string.length() == 0) {
                throw new IOException("ZipOrigin needs anchor for open()");
            }
            return this.openImpl(string);
        }

        private ZipInputStream openImpl() throws IOException {
            if (this.cachedBits == null) {
                try {
                    this.cachedBits = new ByteArray(this.url.openConnection().getInputStream(), true).getBytes();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("interrupted while opening " + this.getName());
                }
            }
            return new ZipInputStream(new ByteArrayInputStream(this.cachedBits));
        }

        protected InputStream openImpl(String string) throws IOException {
            ZipInputStream zipInputStream = this.openImpl();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string)) {
                    return new InputStreamImpl(zipInputStream, (int)zipEntry.getSize());
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            throw new IOException("Couldn't find resource " + string + " in ZIP-file");
        }

        public File getFile() {
            return null;
        }

        public String getFileName() {
            return this.url.getRef();
        }

        public File getFile(String string) {
            return null;
        }
    }

    private static class DefaultOrigin
    extends Origin {
        protected DefaultOrigin(URL uRL) {
            super(uRL);
        }

        public InputStream open() throws IOException {
            URLConnection uRLConnection = this.url.openConnection();
            return new InputStreamImpl(uRLConnection.getInputStream(), uRLConnection.getContentLength());
        }

        protected InputStream openImpl(String string) throws IOException {
            String string2 = this.back2forwardslash(this.url.toString());
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1) + string;
            try {
                URLConnection uRLConnection = new URL(string2).openConnection();
                return new InputStreamImpl(uRLConnection.getInputStream(), uRLConnection.getContentLength());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException.getMessage());
            }
        }

        public String[] list() {
            File file = this.getFile();
            if (file == null) {
                throw new IllegalArgumentException("list() not supported by url protocol");
            }
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            return file.list();
        }

        public File getFile() {
            if (!"file".equals(this.url.getProtocol())) {
                return null;
            }
            return new File(this.url.getFile());
        }

        public File getFile(String string) {
            if (string.length() < 1) {
                return null;
            }
            if (ABSOLUTE.matcher(string).matches()) {
                return new File(string);
            }
            return new File(this.getFile().getParent(), string);
        }
    }
}

