/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class WordBuffer {
    private StringBuffer buffer = new StringBuffer(80);
    private String filler = " ";

    public WordBuffer(String string) {
        this();
        this.setFiller(string);
    }

    public WordBuffer() {
    }

    public WordBuffer setFiller(String string) {
        this.filler = string;
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public WordBuffer append(int n) {
        if (this.buffer.length() > 0) {
            this.buffer.append(this.filler);
        }
        this.buffer.append(n);
        return this;
    }

    public WordBuffer append(Object object) {
        if (object != null) {
            this.append(object.toString());
        }
        return this;
    }

    public WordBuffer append(Object object, String string) {
        if (object == null) {
            return this.append(string);
        }
        return this.append(object.toString(), string);
    }

    public WordBuffer append(String string) {
        return string == null ? this : this.append(string, null);
    }

    public WordBuffer append(String string, String string2) {
        if (string == null || string.length() == 0) {
            return this.append(string2);
        }
        if (this.buffer.length() > 0 && !this.isStartingWithPunctuation(string)) {
            this.buffer.append(this.filler);
        }
        this.buffer.append(string.trim());
        return this;
    }

    private final boolean isStartingWithPunctuation(String string) {
        switch (string.charAt(0)) {
            default: {
                return false;
            }
            case '.': {
                return true;
            }
            case ',': {
                return true;
            }
            case ':': 
        }
        return true;
    }

    public int length() {
        return this.buffer.length();
    }
}

