/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.ChangeSupport;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DateWidget
extends JPanel {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<row><x pad=\"0\"/><x/><x/><x pad=\"0\"/></row>");
    private PopupWidget widgetCalendar;
    private TextFieldWidget widgetDay;
    private TextFieldWidget widgetYear;
    private ChoiceWidget widgetMonth;
    private Calendar calendar;
    private List<SwitchCalendar> switches;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        public void fireChangeEvent(ChangeEvent changeEvent) {
            DateWidget.this.updateStatus();
            super.fireChangeEvent(changeEvent);
        }
    };

    public DateWidget() {
        this(new PointInTime());
    }

    public DateWidget(PointInTime pointInTime) {
        String string;
        this.setOpaque(false);
        this.calendar = pointInTime.getCalendar();
        this.switches = new ArrayList<SwitchCalendar>(PointInTime.CALENDARS.length + 1);
        for (int i = 0; i < PointInTime.CALENDARS.length; ++i) {
            this.switches.add(new SwitchCalendar(PointInTime.CALENDARS[i]));
        }
        this.widgetYear = new TextFieldWidget("", 4);
        this.widgetYear.setSelectAllOnFocus(true);
        this.widgetYear.addChangeListener(this.changeSupport);
        this.widgetMonth = new ChoiceWidget(new Object[0], null);
        this.widgetMonth.setIgnoreCase(true);
        this.widgetMonth.setSelectAllOnFocus(true);
        this.widgetMonth.addChangeListener(this.changeSupport);
        this.widgetDay = new TextFieldWidget("", 2);
        this.widgetDay.setSelectAllOnFocus(true);
        this.widgetDay.addChangeListener(this.changeSupport);
        this.widgetCalendar = new PopupWidget();
        this.widgetCalendar.addItems(this.switches);
        this.setLayout(LAYOUT.copy());
        switch (new SimpleDateFormat().toPattern().charAt(0)) {
            case 'M': 
            case 'm': {
                string = "mmm/dd/yyyy";
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
                this.add(this.widgetYear);
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetDay));
                this.widgetDay.setDocument(new TabbingDoc(this.widgetYear));
                break;
            }
            case 'D': 
            case 'd': {
                string = "dd.mmm.yyyy";
                this.add(this.widgetDay);
                this.add(this.widgetMonth);
                this.add(this.widgetYear);
                this.widgetDay.setDocument(new TabbingDoc(this.widgetMonth));
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetYear));
                break;
            }
            default: {
                string = "yyyy-mmm-dd";
                this.add(this.widgetYear);
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
                this.widgetYear.setDocument(new TabbingDoc(this.widgetMonth));
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetDay));
            }
        }
        this.add(this.widgetCalendar);
        this.widgetDay.setToolTipText(string);
        this.widgetMonth.setToolTipText(string);
        this.widgetYear.setToolTipText(string);
        this.setValue(pointInTime);
        this.updateStatus();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void setValue(PointInTime pointInTime) {
        this.calendar = pointInTime.getCalendar();
        this.widgetCalendar.setToolTipText(this.calendar.getName());
        this.widgetYear.setText(this.calendar.getDisplayYear(pointInTime.getYear()));
        this.widgetDay.setText(this.calendar.getDay(pointInTime.getDay()));
        String[] stringArray = this.calendar.getMonths(true);
        this.widgetMonth.setValues(Arrays.asList(stringArray));
        try {
            this.widgetMonth.setSelectedItem(null);
            this.widgetMonth.setSelectedItem(stringArray[pointInTime.getMonth()]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateStatus();
    }

    public PointInTime getValue() {
        int n;
        int n2;
        int n3;
        int n4;
        block11: {
            String string;
            String string2;
            n3 = n4 = Integer.MAX_VALUE;
            n2 = n4;
            n = n4;
            String string3 = this.widgetDay.getText().trim();
            if (string3.length() > 0) {
                try {
                    n3 = Integer.parseInt(string3) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if ((string2 = this.widgetYear.getText().trim()).length() > 0) {
                try {
                    n = this.calendar.getYear(string2);
                }
                catch (GedcomException gedcomException) {
                    return null;
                }
            }
            if ((string = this.widgetMonth.getText()).length() > 0) {
                try {
                    n2 = Integer.parseInt(string) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    String[] stringArray = this.calendar.getMonths(true);
                    for (n2 = 0; n2 < stringArray.length && !string.equalsIgnoreCase(stringArray[n2]); ++n2) {
                    }
                    if (n2 != stringArray.length) break block11;
                    return null;
                }
            }
        }
        PointInTime pointInTime = new PointInTime(n3, n2, n, this.calendar);
        if (n3 == n4 && n2 == n4 && n == n4 || pointInTime.isValid()) {
            return pointInTime;
        }
        return null;
    }

    private void updateStatus() {
        PointInTime pointInTime = this.getValue();
        if (pointInTime == null) {
            this.widgetCalendar.setEnabled(false);
            this.widgetCalendar.setDisabledIcon(MetaProperty.IMG_ERROR);
        } else {
            this.widgetCalendar.setEnabled(true);
            this.widgetCalendar.setIcon(this.calendar.getImage());
        }
        for (SwitchCalendar switchCalendar : this.switches) {
            switchCalendar.preview();
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public void requestFocus() {
        this.getComponent(0).requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.getComponent(0).requestFocusInWindow();
    }

    private class SwitchCalendar
    extends Action2 {
        private Calendar newCalendar;

        private SwitchCalendar(Calendar calendar) {
            this.newCalendar = calendar;
            this.setImage(this.newCalendar.getImage());
            this.setText(calendar.getName());
        }

        public void preview() {
            WordBuffer wordBuffer = new WordBuffer();
            wordBuffer.append(this.newCalendar.getName());
            wordBuffer.setFiller(" - ");
            try {
                PointInTime pointInTime = DateWidget.this.getValue().getPointInTime(this.newCalendar);
                wordBuffer.append(pointInTime.getDayOfWeek(true));
                wordBuffer.append(pointInTime);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setText(wordBuffer.toString());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PointInTime pointInTime = DateWidget.this.getValue();
            if (pointInTime != null) {
                try {
                    pointInTime.set(this.newCalendar);
                }
                catch (GedcomException gedcomException) {
                    Action[] actionArray = new Action[]{Action2.ok(), new Action2(Calendar.TXT_CALENDAR_RESET)};
                    int n = DialogHelper.openDialog(Calendar.TXT_CALENDAR_SWITCH, 0, gedcomException.getMessage(), actionArray, (Object)DateWidget.this);
                    if (n == 0) {
                        return;
                    }
                    pointInTime = new PointInTime(this.newCalendar);
                }
                DateWidget.this.setValue(pointInTime);
            }
            DateWidget.this.updateStatus();
        }
    }

    private class TabbingDoc
    extends PlainDocument {
        private JComponent next;

        public TabbingDoc(JComponent jComponent) {
            this.next = jComponent;
        }

        private boolean tab(String string) {
            if (string.length() != 1) {
                return false;
            }
            char c = string.charAt(0);
            if (c != '.' && c != '/' && c != '-') {
                return false;
            }
            if (this.next != null) {
                this.next.requestFocusInWindow();
            }
            return true;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.tab(string)) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.tab(string)) {
                return;
            }
            super.replace(n, n2, string, attributeSet);
        }
    }
}

