/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.TextAreaWidget;
import genj.util.swing.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventObject;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogHelper {
    private static final Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;

    public static void showError(String string, String string2, Throwable throwable, Object object) {
        DialogHelper.openDialog(string, 0, string2, (Action[])Action2.okOnly(), object);
    }

    public static void showInfo(String string, String string2, Object object) {
        DialogHelper.openDialog(string, 1, string2, (Action[])Action2.okOnly(), object);
    }

    public static int openDialog(String string, int n, String string2, Action[] actionArray, Object object) {
        Object object2;
        int n2 = 40;
        int n3 = 40;
        int n4 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            if (((String)object2).length() > n2) {
                n3 = n2;
                n4 += ((String)object2).length() / n2;
                continue;
            }
            n3 = Math.max(n3, ((String)object2).length());
            ++n4;
        }
        n4 = Math.min(10, n4);
        object2 = new TextAreaWidget("", n4, n3);
        ((JTextArea)object2).setLineWrap(true);
        ((JTextArea)object2).setWrapStyleWord(true);
        ((JTextComponent)object2).setText(string2);
        ((JTextComponent)object2).setEditable(false);
        ((JTextComponent)object2).setCaretPosition(0);
        ((JComponent)object2).setRequestFocusEnabled(false);
        JScrollPane jScrollPane = new JScrollPane((Component)object2);
        return DialogHelper.openDialog(string, n, jScrollPane, actionArray, object);
    }

    public static int openDialog(String string, int n, JComponent[] jComponentArray, Action[] actionArray, Object object) {
        return new Dialog(string, n, jComponentArray, actionArray, object).show();
    }

    public static String openDialog(String string, int n, String string2, List<String> list, Object object) {
        JLabel jLabel = new JLabel(string2);
        final JList<String> jList = new JList<String>(list.toArray(new String[list.size()]));
        jList.setSelectionMode(0);
        final Action[] actionArray = Action2.okCancel();
        jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                actionArray[0].setEnabled(jList.getSelectedIndex() >= 0);
            }
        });
        int n2 = DialogHelper.openDialog(string, n, new JComponent[]{jLabel, new JScrollPane(jList)}, actionArray, object);
        return n2 == 0 ? jList.getSelectedValue() : null;
    }

    public static String openDialog(String string, int n, String string2, String string3, Object object) {
        JLabel jLabel = new JLabel(string2);
        final TextFieldWidget textFieldWidget = new TextFieldWidget(string3, 24);
        final Action[] actionArray = Action2.okCancel();
        textFieldWidget.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                actionArray[0].setEnabled(textFieldWidget.getText().length() > 0);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        int n2 = DialogHelper.openDialog(string, n, new JComponent[]{jLabel, textFieldWidget}, actionArray, object);
        return n2 == 0 ? textFieldWidget.getText().trim() : null;
    }

    public static int openDialog(String string, int n, JComponent jComponent, Action[] actionArray, Object object) {
        return new Dialog(string, n, jComponent, actionArray, object).show();
    }

    public static Window getWindow(EventObject eventObject) {
        if (!(eventObject.getSource() instanceof Component)) {
            throw new IllegalArgumentException("can't find window for event without component source");
        }
        if (eventObject.getSource() instanceof Window) {
            return (Window)eventObject.getSource();
        }
        return (Window)DialogHelper.visitOwners((Component)eventObject.getSource(), new ComponentVisitor(){

            public Component visit(Component component, Component component2) {
                return component instanceof Window ? component : null;
            }
        });
    }

    private static StackTraceElement getCaller() {
        String string = DialogHelper.class.getName();
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            if (string.equals(stackTraceElement.getClassName())) continue;
            return stackTraceElement;
        }
        return new StackTraceElement("Class", "method", "file", 0);
    }

    public static Component visitContainers(Component component, ComponentVisitor componentVisitor) {
        Container container;
        do {
            Component component2;
            if ((component2 = componentVisitor.visit(container = component.getParent(), component)) == null) continue;
            return component2;
        } while ((component = container) != null);
        return null;
    }

    public static Component visitOwners(Component component, ComponentVisitor componentVisitor) {
        Component component2;
        do {
            if (component instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component).getInvoker();
            } else if (component instanceof JMenu) {
                component2 = ((JMenu)component).getParent();
            } else if (component instanceof JMenuItem) {
                component2 = ((JMenuItem)component).getParent();
            } else if (component instanceof JDialog) {
                component2 = ((JDialog)component).getOwner();
            } else if (component != null) {
                component2 = component.getParent();
            } else {
                return null;
            }
            Component component3 = componentVisitor.visit(component2, component);
            if (component3 == null) continue;
            return component3;
        } while ((component = component2) != null);
        return null;
    }

    public static Component visitOwners(EventObject eventObject, ComponentVisitor componentVisitor) {
        return DialogHelper.visitOwners((Component)eventObject.getSource(), componentVisitor);
    }

    private static void patchOpaque(Component component, boolean bl) {
        if (component instanceof JTabbedPane) {
            bl = false;
        }
        if (component instanceof JComponent && !(component instanceof JTextField) && !(component instanceof JScrollPane) && !bl) {
            ((JComponent)component).setOpaque(bl);
        }
        if (component instanceof Container && !(component instanceof JScrollPane)) {
            for (Component component2 : ((Container)component).getComponents()) {
                DialogHelper.patchOpaque(component2, bl);
            }
        }
    }

    public static boolean isContained(Component component, final Container container) {
        return container == DialogHelper.visitContainers(component, new ComponentVisitor(){

            public Component visit(Component component, Component component2) {
                if (component == container) {
                    return component;
                }
                return null;
            }
        });
    }

    public static interface ComponentVisitor {
        public Component visit(Component var1, Component var2);
    }

    private static class Content
    extends JOptionPane {
        private JDialog dlg;
        private JComponent content;

        private Content(int n, JComponent jComponent, Action[] actionArray) {
            super(new JLabel(), n, -1, null, new String[0]);
            this.content = jComponent;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("Center", jComponent);
            this.setMessage(jPanel);
            Object[] objectArray = new Option[actionArray.length];
            for (int i = 0; i < actionArray.length; ++i) {
                objectArray[i] = new Option(actionArray[i]);
            }
            this.setOptions(objectArray);
            if (objectArray.length > 0) {
                this.setInitialValue(objectArray[0]);
            }
        }

        public JDialog createDialog(Component component, String string) throws HeadlessException {
            this.dlg = super.createDialog(component, string);
            return this.dlg;
        }

        public void doLayout() {
            super.doLayout();
            if (this.dlg != null) {
                Dimension dimension = this.getSize();
                Dimension dimension2 = this.getMinimumSize();
                Dimension dimension3 = this.dlg.getSize();
                boolean bl = false;
                if (bl |= dimension2.width > dimension.width) {
                    dimension3.width += dimension2.width - dimension.width;
                }
                if (bl |= dimension2.height > dimension.height) {
                    dimension3.height += dimension2.height - dimension.height;
                }
                if (bl) {
                    this.dlg.setSize(dimension3);
                }
            }
        }

        private class Option
        extends JButton
        implements ActionListener {
            private Option(Action action) {
                super(action);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Content.this.setValue(this.getAction());
            }
        }
    }

    public static class Dialog {
        public static final String CLIENT_PROPERTY_JCOMPONENT_RECEIVING_FOCUS = "CLIENT_PROPERTY_JCOMPONENT_RECEIVING_FOCUS";
        private String title;
        private int messageType;
        private final JComponent content;
        private Action[] actions;
        private Component parent;
        private JDialog dlg;
        private JOptionPane optionPane;

        public Dialog(String string, int n, JComponent[] jComponentArray, Action[] actionArray, Object object) {
            this(string, n, Dialog.box(jComponentArray), actionArray, object);
        }

        private static JComponent box(JComponent[] jComponentArray) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            for (int i = 0; i < jComponentArray.length; ++i) {
                if (jComponentArray[i] == null) continue;
                jPanel.add(jComponentArray[i]);
                jComponentArray[i].setAlignmentX(0.0f);
            }
            return jPanel;
        }

        public Dialog(String string, int n, JComponent jComponent, Action[] actionArray, Object object) {
            this.title = string;
            this.messageType = n;
            this.content = jComponent;
            this.actions = actionArray != null ? actionArray : Action2.okOnly();
            this.parent = null;
            if (object instanceof Component) {
                this.parent = (Component)object;
            } else if (object instanceof EventObject && ((EventObject)object).getSource() instanceof Component) {
                this.parent = DialogHelper.visitOwners((Component)((EventObject)object).getSource(), new ComponentVisitor(){

                    public Component visit(Component component, Component component2) {
                        return component == null ? component2 : null;
                    }
                });
            }
            DialogHelper.patchOpaque(jComponent, true);
        }

        public int show() {
            this.optionPane = new Content(this.messageType, this.content, this.actions);
            this.dlg = this.optionPane.createDialog(this.parent, this.title);
            this.dlg.setResizable(true);
            this.dlg.setModal(true);
            this.dlg.pack();
            this.dlg.setMinimumSize(this.content.getMinimumSize());
            StackTraceElement stackTraceElement = DialogHelper.getCaller();
            final Registry registry = Registry.get(stackTraceElement.getClassName());
            final String string = stackTraceElement.getMethodName() + (stackTraceElement.getLineNumber() > 0 ? Integer.valueOf(stackTraceElement.getLineNumber()) : "") + ".dialog";
            Dimension dimension = registry.get(string, (Dimension)null);
            if (dimension != null) {
                dimension.width = Math.max(dimension.width, this.dlg.getWidth());
                dimension.height = Math.max(dimension.height, this.dlg.getHeight());
                this.dlg.setBounds(new Rectangle(dimension).intersection(screen));
            }
            this.dlg.setLocationRelativeTo(this.parent);
            this.dlg.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    Object object = Dialog.this.content.getClientProperty(Dialog.CLIENT_PROPERTY_JCOMPONENT_RECEIVING_FOCUS);
                    if (object instanceof JComponent) {
                        ((JComponent)object).requestFocus();
                    } else {
                        Dialog.this.content.requestFocus();
                    }
                }

                public void componentHidden(ComponentEvent componentEvent) {
                    registry.put(string, Dialog.this.dlg.getSize());
                    Dialog.this.dlg.dispose();
                    Dialog.this.dlg.removeComponentListener(this);
                    Dialog.this.dlg = null;
                }
            });
            this.dlg.setVisible(true);
            Object object = this.optionPane.getValue();
            for (int i = 0; i < this.actions.length; ++i) {
                if (object != this.actions[i]) continue;
                return i;
            }
            return -1;
        }

        public void close(int n) {
            this.optionPane.setValue(this.actions[n]);
            this.dlg.dispose();
        }

        public void cancel() {
            if (this.dlg == null) {
                throw new IllegalStateException("not showing");
            }
            this.dlg.dispose();
        }
    }
}

