/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class EditorHyperlinkSupport
implements HyperlinkListener {
    private static final Logger LOG = Logger.getLogger("genj.log");
    private JEditorPane editor;

    public EditorHyperlinkSupport(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (hyperlinkEvent.getDescription().startsWith("#")) {
            this.editor.scrollToReference(hyperlinkEvent.getDescription().substring(1));
        } else {
            try {
                this.handleHyperlink(hyperlinkEvent.getDescription());
            }
            catch (Throwable throwable) {
                LOG.log(Level.INFO, "can't open browser for " + hyperlinkEvent.getDescription());
            }
        }
    }

    protected void handleHyperlink(String string) throws IOException, URISyntaxException {
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, "can't browse link " + string, throwable);
        }
    }
}

