/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.EnvironmentChecker;
import genj.util.swing.GraphicsHelper;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class HeadlessLabel
extends JComponent {
    private int iconTextGap = 4;
    private int padding = 0;
    private String txt = "";
    private Icon icon;
    private float iconLocation = 0.0f;
    private boolean isOpaque = false;
    private Font font;
    private int horizontalAlignment = 2;

    public HeadlessLabel() {
    }

    public HeadlessLabel(Font font) {
        this.setFont(font);
    }

    public void setHorizontalAlignment(int n) {
        switch (n) {
            case 2: {
                this.horizontalAlignment = 2;
                break;
            }
            case 4: {
                this.horizontalAlignment = 4;
                this.icon = null;
                break;
            }
            case 0: {
                this.horizontalAlignment = 0;
                this.icon = null;
            }
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public void setText(String string) {
        this.txt = string != null ? string : "";
    }

    public void setBorder(Border border) {
        throw new IllegalArgumentException("don't set border on headless label");
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.horizontalAlignment = 2;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public void setOpaque(boolean bl) {
        this.isOpaque = bl;
    }

    public void setIconLocation(float f) {
        this.iconLocation = f;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.txt);
        int n2 = fontMetrics.getHeight();
        String string = EnvironmentChecker.getProperty("genj.label.height", "", "check overriden label height");
        if (string != null) {
            try {
                n2 = Math.max(n2, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.icon != null) {
            n += this.icon.getIconWidth();
            n2 = Math.max(n2, this.icon.getIconHeight());
        }
        if (this.txt.length() > 0 && this.icon != null) {
            n += this.iconTextGap;
        }
        return new Dimension(n += this.padding + this.padding, n2 += this.padding + this.padding);
    }

    public void paint(Graphics graphics) {
        Font font = this.getFont();
        Rectangle rectangle = new Rectangle(new Point(), this.getSize());
        if (this.isOpaque) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.padding > 0) {
            rectangle.x += this.padding;
            rectangle.y += this.padding;
            rectangle.width -= this.padding + this.padding;
            rectangle.height -= this.padding + this.padding;
        }
        if (this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.icon.paintIcon(null, graphics, 0, (int)(this.iconLocation * (float)(rectangle.height - n2)));
            rectangle.x += n + this.iconTextGap;
            rectangle.width -= n + this.iconTextGap;
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(font);
        switch (this.horizontalAlignment) {
            case 4: {
                GraphicsHelper.render((Graphics2D)graphics, this.txt, rectangle.getMaxX(), rectangle.getCenterY(), 1.0, 0.5);
                break;
            }
            case 2: {
                GraphicsHelper.render((Graphics2D)graphics, this.txt, rectangle.getMinX(), rectangle.getCenterY(), 0.0, 0.5);
                break;
            }
            case 0: {
                GraphicsHelper.render((Graphics2D)graphics, this.txt, rectangle.getCenterX(), rectangle.getCenterY(), 0.5, 0.5);
            }
        }
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

