/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSelectionWidget<T>
extends JComponent {
    private JList lChoose;
    private List<T> choices = new ArrayList<T>();
    private Set<T> selection = null;
    private ChangeSupport changes = new ChangeSupport(this);

    public ListSelectionWidget() {
        this.lChoose = new JList();
        this.lChoose.setCellRenderer(new Renderer());
        this.lChoose.setSelectionMode(0);
        this.lChoose.addMouseListener(new SelectionListener());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.lChoose), "Center");
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changes.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changes.removeChangeListener(changeListener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.lChoose.addMouseListener(mouseListener);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.lChoose.removeMouseListener(mouseListener);
    }

    public T getChoice(Point point) {
        int n = this.lChoose.locationToIndex(point);
        return n < 0 || n > this.choices.size() - 1 ? null : (T)this.choices.get(n);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    private void update() {
        this.lChoose.setListData(this.choices.toArray(new Object[this.choices.size()]));
        this.changes.fireChangeEvent();
    }

    public void addChoice(T t) {
        this.choices.add(t);
        this.update();
    }

    public void removeChoice(T t) {
        this.choices.remove(t);
        this.update();
    }

    public List<T> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public void setChoices(T[] TArray) {
        this.choices.clear();
        this.choices.addAll(Arrays.asList(TArray));
        this.update();
    }

    public void setChoices(Collection<T> collection) {
        this.choices = new ArrayList<T>(collection);
        this.update();
    }

    public void setCheckedChoices(Set<T> set) {
        this.selection = new HashSet<T>(set);
        for (T t : set) {
            if (this.choices.contains(t)) continue;
            this.choices.add(t);
        }
        this.update();
    }

    public Set<T> getCheckedChoices() {
        if (this.selection == null) {
            this.selection = new HashSet<T>();
        }
        return Collections.unmodifiableSet(this.selection);
    }

    public T getSelectedChoice() {
        return (T)this.lChoose.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.lChoose.getSelectedIndex();
    }

    public void swapChoices(int n, int n2) {
        int n3 = this.lChoose.getSelectedIndex();
        T t = this.choices.get(n);
        this.choices.set(n, this.choices.get(n2));
        this.choices.set(n2, t);
        this.update();
        if (n3 == n) {
            this.lChoose.setSelectedIndex(n2);
        }
        if (n3 == n2) {
            this.lChoose.setSelectedIndex(n);
        }
    }

    public void down() {
        int n = this.lChoose.getSelectedIndex();
        if (n == -1 || n == this.choices.size() - 1) {
            return;
        }
        T t = this.choices.get(n);
        this.choices.set(n, this.choices.get(n + 1));
        this.choices.set(n + 1, t);
        this.update();
        this.lChoose.setSelectedIndex(n + 1);
    }

    protected String getText(T t) {
        return t.toString();
    }

    protected ImageIcon getIcon(T t) {
        return null;
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.lChoose.addListSelectionListener(listSelectionListener);
    }

    public void removeSelectionListener(ListSelectionListener listSelectionListener) {
        this.lChoose.removeListSelectionListener(listSelectionListener);
    }

    private class SelectionListener
    extends MouseAdapter {
        private SelectionListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ListSelectionWidget.this.selection == null) {
                return;
            }
            int n = ListSelectionWidget.this.lChoose.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Object e = ListSelectionWidget.this.choices.get(n);
            if (!ListSelectionWidget.this.selection.remove(e)) {
                ListSelectionWidget.this.selection.add(e);
            }
            ListSelectionWidget.this.lChoose.repaint(ListSelectionWidget.this.lChoose.getCellBounds(n, n));
            ListSelectionWidget.this.changes.fireChangeEvent();
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox check = new JCheckBox();

        private Renderer() {
            this.check.setOpaque(false);
            this.panel.setOpaque(true);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.check, "West");
            this.panel.add((Component)this, "Center");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(ListSelectionWidget.this.getText(object));
            this.setIcon(ListSelectionWidget.this.getIcon(object));
            if (ListSelectionWidget.this.selection == null) {
                return this;
            }
            this.panel.setBackground(super.getBackground());
            this.check.setSelected(ListSelectionWidget.this.selection.contains(object));
            return this.panel;
        }
    }
}

