/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.Action2;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWidget<ROW>
extends JTable {
    private List<Column> columns = new ArrayList<Column>();
    private Mouser mouser = new Mouser();

    public TableWidget() {
        super(new DefaultTableModel(), new DefaultTableColumnModel());
        this.setModel(new Model());
        this.setPreferredScrollableViewportSize(new Dimension(32, 32));
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setFillsViewportHeight(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(this.mouser);
        this.addMouseMotionListener(this.mouser);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof Action2) {
            return new ActionRenderer();
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        if (n < 0 || n2 < 0) {
            return null;
        }
        Object object = this.getValueAt(n2, n);
        if (!(object instanceof Action2)) {
            return null;
        }
        Action2 action2 = (Action2)object;
        String string = action2.getTip();
        if (string != null) {
            return string;
        }
        return action2.getText();
    }

    public void setRows(List<ROW> list) {
        this.model().setRows(list);
    }

    public void addRow(ROW ROW) {
        this.model().addRow(ROW);
    }

    public void deleteRow(ROW ROW) {
        this.model().delRow(ROW);
    }

    private Model model() {
        return (Model)this.getModel();
    }

    private static class ActionRenderer
    extends DefaultTableCellRenderer {
        private ActionRenderer() {
        }

        protected void setValue(Object object) {
            if (object != null) {
                super.setIcon(((Action2)object).getImage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Mouser
    extends MouseAdapter
    implements MouseMotionListener {
        private Mouser() {
        }

        private ROW getRow(MouseEvent mouseEvent) {
            int n = TableWidget.this.rowAtPoint(mouseEvent.getPoint());
            return n < 0 ? null : TableWidget.this.model().getRow(n);
        }

        private Column getColumn(MouseEvent mouseEvent) {
            int n = TableWidget.this.columnAtPoint(mouseEvent.getPoint());
            return n < 0 ? null : (Column)TableWidget.this.columns.get(n);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Object object;
            Cursor cursor = null;
            Column column = this.getColumn(mouseEvent);
            Object ROW = this.getRow(mouseEvent);
            if (ROW != null && (object = column.getValue(ROW)) instanceof Action) {
                cursor = Cursor.getPredefinedCursor(12);
            }
            TableWidget.this.setCursor(cursor);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            int n = TableWidget.this.columnAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            Column column = (Column)TableWidget.this.columns.get(n);
            Object ROW = this.getRow(mouseEvent);
            if (ROW != null && (object = column.getValue(ROW)) instanceof Action) {
                ((Action)object).actionPerformed(new ActionEvent(TableWidget.this, n, ""));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Column {
        protected Column(String string) {
            this(string, String.class);
        }

        protected Column(String string, Class<?> clazz) {
            TableWidget.this.columns.add(this);
            TableColumn tableColumn = new TableColumn(TableWidget.this.columns.size() - 1);
            if (Action2.class.isAssignableFrom(clazz)) {
                tableColumn.setMaxWidth(16);
            }
            tableColumn.setHeaderValue(string);
            TableWidget.this.getColumnModel().addColumn(tableColumn);
        }

        public abstract Object getValue(ROW var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractTableModel {
        private List<ROW> rows = new ArrayList();

        private Model() {
        }

        private void setRows(List<ROW> list) {
            if (!this.rows.isEmpty()) {
                int n = this.rows.size();
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
            this.rows.addAll(list);
            if (!this.rows.isEmpty()) {
                this.fireTableRowsInserted(0, this.rows.size() - 1);
            }
        }

        private void addRow(ROW ROW) {
            this.rows.add(ROW);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        private void delRow(ROW ROW) {
            int n = this.rows.indexOf(ROW);
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        private ROW getRow(int n) {
            return this.rows.get(n);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return TableWidget.this.columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ((Column)TableWidget.this.columns.get(n2)).getValue(this.rows.get(n));
        }

        @Override
        public String getColumnName(int n) {
            return TableWidget.this.getColumnModel().getColumn(n).getHeaderValue().toString();
        }
    }
}

