/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;

public class UnitGraphics {
    private Stack stackTransformations = new Stack();
    private Stack clipStack = new Stack();
    private double unitx = 1.0;
    private double unity = 1.0;
    private Graphics2D graphics;
    private Line2D.Double line = new Line2D.Double();

    public UnitGraphics(Graphics graphics, double d, double d2) {
        this.graphics = (Graphics2D)graphics;
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.pushTransformation();
        this.unitx = d;
        this.unity = d2;
    }

    public Point2D getUnit() {
        return new Point2D.Double(this.unitx, this.unity);
    }

    public void setAntialiasing(boolean bl) {
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void translate(double d, double d2) {
        this.graphics.translate((int)(d * this.unitx), (int)(d2 * this.unity));
    }

    public void scale(double d, double d2) {
        this.graphics.scale(d * this.unitx, d2 * this.unity);
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public Rectangle2D getClip() {
        Rectangle rectangle = this.graphics.getClipBounds();
        return new Rectangle2D.Double(rectangle.getMinX() / this.unitx, rectangle.getMinY() / this.unity, rectangle.getWidth() / this.unitx, rectangle.getHeight() / this.unity);
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.graphics.setColor(color);
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.graphics.setFont(font);
        }
    }

    public void draw(double d, double d2, double d3, double d4) {
        this.line.setLine(d * this.unitx, d2 * this.unity, d3 * this.unitx, d4 * this.unity);
        this.graphics.draw(this.line);
    }

    public void draw(String string, double d, double d2, double d3, double d4) {
        this.draw(string, d, d2, d3, d4, 0, 0);
    }

    public void draw(String string, double d, double d2, double d3, double d4, int n, int n2) {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.graphics);
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, this.graphics);
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getHeight();
        d = d * this.unitx - (double)f * d3 + (double)n;
        d2 = d2 * this.unity - (double)f2 * d4 + (double)f2 - (double)lineMetrics.getDescent() + (double)n2;
        this.graphics.drawString(string, (float)d, (float)d2);
    }

    public void draw(Shape shape, double d, double d2) {
        this.draw(shape, d, d2, false);
    }

    public void draw(Shape shape, double d, double d2, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.unitx, this.unity);
        affineTransform.translate(d, d2);
        GeneralPath generalPath = new GeneralPath(shape);
        generalPath.transform(affineTransform);
        shape = generalPath;
        if (bl) {
            this.graphics.fill(shape);
        } else {
            this.graphics.draw(shape);
        }
    }

    public void draw(ImageIcon imageIcon, double d, double d2, double d3, double d4) {
        int n = (int)(d * this.unitx - d3 * (double)imageIcon.getIconWidth());
        int n2 = (int)(d2 * this.unity - d4 * (double)imageIcon.getIconHeight());
        imageIcon.paintIcon(this.graphics, n, n2);
    }

    public void popTransformation() {
        this.graphics.setTransform((AffineTransform)this.stackTransformations.pop());
    }

    public void pushTransformation() {
        this.stackTransformations.push(this.graphics.getTransform());
    }

    public void pushClip(double d, double d2, Rectangle2D rectangle2D) {
        this.pushClip(d + rectangle2D.getMinX(), d2 + rectangle2D.getMinY(), d + rectangle2D.getMaxX(), d2 + rectangle2D.getMaxY());
    }

    public void pushClip(Rectangle2D rectangle2D) {
        this.pushClip(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public void pushClip(double d, double d2, double d3, double d4) {
        this.clipStack.push(this.graphics.getClip());
        double d5 = d * this.unitx;
        double d6 = d2 * this.unity;
        double d7 = d3 * this.unitx - d5;
        double d8 = d4 * this.unity - d6;
        this.graphics.clip(new Rectangle2D.Double(d5, d6, d7, d8));
    }

    public void popClip() {
        this.graphics.setClip((Shape)this.clipStack.pop());
    }

    public Rectangle getRectangle(Rectangle2D rectangle2D) {
        int n = (int)Math.ceil(rectangle2D.getMinX() * this.unitx);
        int n2 = (int)Math.ceil(rectangle2D.getMinY() * this.unity);
        int n3 = (int)Math.floor(rectangle2D.getMaxX() * this.unitx);
        int n4 = (int)Math.floor(rectangle2D.getMaxY() * this.unity);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }
}

