/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.Pack;
import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.WrappedNativeLibException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class RegistryInstallerListener
extends NativeInstallerListener {
    private static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";

    public RegistryInstallerListener() {
        super(true);
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.initializeRegistryHandler(idata);
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        try {
            List info;
            String uninstallSuffix;
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                return;
            }
            XMLElement uninstallerPack = null;
            Unpacker.setDiscardInterrupt(true);
            rh.activateLogging();
            if (this.getSpecHelper().getSpec() != null) {
                VariableSubstitutor substitutor = new VariableSubstitutor(idata.getVariables());
                Iterator iter = idata.selectedPacks.iterator();
                uninstallerPack = this.getSpecHelper().getPackForName("UninstallStuff");
                this.performPack(uninstallerPack, substitutor);
                while (iter != null && iter.hasNext()) {
                    XMLElement pack = this.getSpecHelper().getPackForName(((Pack)iter.next()).name);
                    this.performPack(pack, substitutor);
                }
            }
            if ((uninstallSuffix = idata.getVariable("UninstallKeySuffix")) != null) {
                rh.setUninstallName(rh.getUninstallName() + " " + uninstallSuffix);
            }
            if (uninstallerPack == null) {
                rh.registerUninstallKey();
            }
            if ((info = rh.getLoggingInfo()) != null) {
                UninstallData.getInstance().addAdditionalData("registryEntries", info);
            }
        }
        catch (Exception e) {
            if (e instanceof NativeLibException) {
                throw new WrappedNativeLibException(e);
            }
            throw e;
        }
    }

    private void performPack(XMLElement pack, VariableSubstitutor substitutor) throws Exception {
        if (pack == null) {
            return;
        }
        Vector regEntries = pack.getChildren();
        if (regEntries == null) {
            return;
        }
        Iterator entriesIter = regEntries.iterator();
        while (entriesIter != null && entriesIter.hasNext()) {
            XMLElement regEntry = (XMLElement)entriesIter.next();
            String type = regEntry.getName();
            if (type.equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(regEntry, substitutor);
                continue;
            }
            if (type.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(regEntry, substitutor);
                continue;
            }
            this.getSpecHelper().parseError(regEntry, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(XMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        SpecHelper specHelper = this.getSpecHelper();
        String name = specHelper.getRequiredAttribute(regEntry, REG_BASENAME);
        name = substitutor.substitute(name, null);
        String keypath = specHelper.getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath, null);
        String root = specHelper.getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        String override = regEntry.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(override) && rh.getValue(keypath, name, null) != null) {
            return;
        }
        String value = regEntry.getAttribute(REG_DWORD);
        if (value != null) {
            value = substitutor.substitute(value, null);
            rh.setValue(keypath, name, Long.parseLong(value));
            return;
        }
        value = regEntry.getAttribute(REG_STRING);
        if (value != null) {
            value = substitutor.substitute(value, null);
            rh.setValue(keypath, name, value);
            return;
        }
        Vector values = regEntry.getChildrenNamed(REG_MULTI);
        if (values != null && !values.isEmpty()) {
            Iterator multiIter = values.iterator();
            String[] multiString = new String[values.size()];
            int i = 0;
            while (multiIter.hasNext()) {
                XMLElement element = (XMLElement)multiIter.next();
                multiString[i] = specHelper.getRequiredAttribute(element, REG_DATA);
                multiString[i] = substitutor.substitute(multiString[i], null);
                ++i;
            }
            rh.setValue(keypath, name, multiString);
            return;
        }
        values = regEntry.getChildrenNamed(REG_BIN);
        if (values != null && !values.isEmpty()) {
            Iterator multiIter = values.iterator();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (multiIter.hasNext()) {
                XMLElement element = (XMLElement)multiIter.next();
                String tmp = specHelper.getRequiredAttribute(element, REG_DATA);
                buf.append(tmp);
                if (!tmp.endsWith(",") && multiIter.hasNext()) {
                    buf.append(",");
                }
                ++i;
            }
            byte[] bytes = this.extractBytes(regEntry, substitutor.substitute(buf.toString(), null));
            rh.setValue(keypath, name, bytes);
            return;
        }
        specHelper.parseError(regEntry, "No data found.");
    }

    private byte[] extractBytes(XMLElement element, String byteString) throws Exception {
        StringTokenizer st = new StringTokenizer(byteString, ",");
        byte[] retval = new byte[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte value = 0;
            String token = st.nextToken().trim();
            try {
                int tval = Integer.parseInt(token, 16);
                if (tval < 0 || tval > 255) {
                    throw new NumberFormatException("Value out of range.");
                }
                if (tval > 127) {
                    tval -= 256;
                }
                value = (byte)tval;
            }
            catch (NumberFormatException nfe) {
                this.getSpecHelper().parseError(element, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvalue followed by a ','.");
            }
            retval[i++] = value;
        }
        return retval;
    }

    private void performKeySetting(XMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        String keypath = this.getSpecHelper().getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath, null);
        String root = this.getSpecHelper().getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        if (!rh.keyExist(keypath)) {
            rh.createKey(keypath);
        }
    }

    private int resolveRoot(XMLElement regEntry, String root, VariableSubstitutor substitutor) throws Exception {
        String root1 = substitutor.substitute(root, null);
        Integer tmp = (Integer)RegistryHandler.ROOT_KEY_MAP.get(root1);
        if (tmp != null) {
            return tmp;
        }
        this.getSpecHelper().parseError(regEntry, "Unknown value (" + root1 + ")for registry root.");
        return 0;
    }

    private void initializeRegistryHandler(AutomatedInstallData idata) throws Exception {
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.verify(idata);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
    }
}

