/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class RulesEngine {
    protected Map panelconditions;
    protected Map packconditions;
    protected Map optionalpackconditions;
    protected XMLElement conditionsspec;
    protected static Map conditionsmap = new Hashtable();
    protected InstallData installdata;

    public RulesEngine(XMLElement conditionsspecxml, InstallData installdata) {
        this.conditionsspec = conditionsspecxml;
        conditionsmap = new Hashtable();
        this.panelconditions = new Hashtable();
        this.packconditions = new Hashtable();
        this.optionalpackconditions = new Hashtable();
        this.installdata = installdata;
        this.readConditions();
    }

    protected boolean checkAttribute(String val, String attribute, String element) {
        if (val != null && val.length() > 0) {
            return true;
        }
        Debug.trace("Element " + element + " has to specify an attribute " + attribute);
        return false;
    }

    public static Condition analyzeCondition(XMLElement condition) {
        String condid = condition.getAttribute("id");
        String condtype = condition.getAttribute("type");
        Condition result = null;
        if (condtype != null) {
            String conditiontype = condtype.toLowerCase();
            String conditionclassname = "com.izforge.izpack.rules." + conditiontype.substring(0, 1).toUpperCase() + conditiontype.substring(1, conditiontype.length());
            conditionclassname = conditionclassname + "Condition";
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            try {
                Class<?> conditionclass = loader.loadClass(conditionclassname);
                result = (Condition)conditionclass.newInstance();
            }
            catch (ClassNotFoundException e) {
                Debug.trace(conditionclassname + " not found.");
            }
            catch (InstantiationException e) {
                Debug.trace(conditionclassname + " couldn't be instantiated.");
            }
            catch (IllegalAccessException e) {
                Debug.trace("Illegal access to " + conditionclassname);
            }
            result.readFromXML(condition);
            result.setId(condid);
        }
        return result;
    }

    protected void readConditions() {
        if (this.conditionsspec == null) {
            Debug.trace("No specification for conditions found.");
            return;
        }
        try {
            if (this.conditionsspec.hasChildren()) {
                Vector childs = this.conditionsspec.getChildrenNamed("condition");
                for (int i = 0; i < childs.size(); ++i) {
                    String condid;
                    XMLElement condition = (XMLElement)childs.get(i);
                    Condition cond = RulesEngine.analyzeCondition(condition);
                    if (cond == null || (condid = cond.getId()) == null || "UNKNOWN".equals(condid)) continue;
                    conditionsmap.put(condid, cond);
                }
                Vector panelconditionels = this.conditionsspec.getChildrenNamed("panelcondition");
                for (int i = 0; i < panelconditionels.size(); ++i) {
                    XMLElement panelel = (XMLElement)panelconditionels.get(i);
                    String panelid = panelel.getAttribute("panelid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.panelconditions.put(panelid, conditionid);
                }
                Vector packconditionels = this.conditionsspec.getChildrenNamed("packcondition");
                for (int i = 0; i < packconditionels.size(); ++i) {
                    boolean optionalinstall;
                    XMLElement panelel = (XMLElement)packconditionels.get(i);
                    String panelid = panelel.getAttribute("packid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.packconditions.put(panelid, conditionid);
                    String optional = panelel.getAttribute("optional");
                    if (optional == null || !(optionalinstall = Boolean.valueOf(optional).booleanValue())) continue;
                    this.optionalpackconditions.put(panelid, conditionid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Condition getCondition(String id) {
        return (Condition)conditionsmap.get(id);
    }

    public boolean isConditionTrue(String id, Properties variables) {
        Condition cond = (Condition)conditionsmap.get(id);
        if (cond == null) {
            Debug.trace("Condition (" + id + ") not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return cond.isTrue(variables, this.installdata.selectedPacks);
    }

    public boolean isConditionTrue(Condition cond, Properties variables) {
        if (cond == null) {
            Debug.trace("Condition not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return cond.isTrue(variables, this.installdata.selectedPacks);
    }

    public boolean canShowPanel(String panelid, Properties variables) {
        Debug.trace("can show panel with id " + panelid + " ?");
        if (!this.panelconditions.containsKey(panelid)) {
            Debug.trace("no condition, show panel");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = (Condition)conditionsmap.get(this.panelconditions.get(panelid));
        if (condition != null) {
            return condition.isTrue(variables, this.installdata.selectedPacks);
        }
        return false;
    }

    public boolean canInstallPack(String packid, Properties variables) {
        Debug.trace("can install pack with id " + packid + "?");
        if (!this.packconditions.containsKey(packid)) {
            Debug.trace("no condition, can install pack");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = (Condition)conditionsmap.get(this.packconditions.get(packid));
        if (condition != null) {
            return condition.isTrue(variables, this.installdata.selectedPacks);
        }
        return false;
    }

    public boolean canInstallPackOptional(String packid, Properties variables) {
        Debug.trace("can install pack optional with id " + packid + "?");
        if (!this.optionalpackconditions.containsKey(packid)) {
            Debug.trace("not in optionalpackconditions.");
            return false;
        }
        Debug.trace("optional install possible");
        return true;
    }
}

