/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import jgpstrackedit.config.ConfigurationObserver;
import jgpstrackedit.international.International;
import jgpstrackedit.util.Parser;

public class Configuration {
    private static Properties properties = null;
    private static ArrayList<ConfigurationObserver> observers = new ArrayList();

    public static void addConfigurationObserver(ConfigurationObserver observer) {
        observers.add(observer);
    }

    public static void removeConfigurationObserver(ConfigurationObserver observer) {
        observers.remove(observer);
    }

    protected static void notifyConfigurationObservers() {
        for (ConfigurationObserver observer : observers) {
            observer.configurationChanged();
        }
    }

    protected static void checkInit() {
        if (properties == null) {
            properties = new Properties();
            properties.setProperty("SHOW_MAP_ON_STARTUP", "1");
            properties.setProperty("MAX_TILES_IN_MEMORY", "250");
            properties.setProperty("SELECTED_LINE_WIDTH", "1");
            properties.setProperty("UNSELECTED_LINE_WIDTH", "1");
            properties.setProperty("POINT_DIAMETER", "7");
            properties.setProperty("SHOW_DIRECTION_BUTTONS", "0");
            properties.setProperty("SHOW_HELP_ON_STARTUP", "1");
            properties.setProperty("COUNTRY_SPECIFIC_MAP", "1");
            properties.setProperty("MAPEXTRACT", "");
            properties.setProperty("GUILOOKFEEL", "System");
            properties.setProperty("ROUTINGTYPE", "bicycle");
            properties.setProperty("ROUTINGPOINTDISTANCE", "10");
            properties.setProperty("ROUTINGAVOIDLIMITEDACCESS", "1");
            properties.setProperty("ROUTINGAVOIDTOLLROAD", "1");
            properties.setProperty("AVERAGESPEED", "20.0");
            properties.setProperty("INCLINETIME100METERS", "10.0");
            properties.setProperty("BREAKRATIO", "0.5");
            properties.setProperty("MAXTOURTIME", "8.0");
            properties.setProperty("MAPTYPE", "OpenStreetMap");
            properties.setProperty("LOCALE", Locale.getDefault().toString());
            try {
                FileInputStream inStream = new FileInputStream("JGPSTrackEdit.properties");
                properties.load(inStream);
                inStream.close();
            }
            catch (FileNotFoundException e) {
                properties.list(System.out);
                Configuration.saveProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            International.setCurrentLocale(new Locale(properties.getProperty("LOCALE").split("_")[0], properties.getProperty("LOCALE").split("_")[1]));
            System.out.println(International.getCurrentLocale());
        }
    }

    public static String getProperty(String property) {
        Configuration.checkInit();
        String s = (String)properties.get(property);
        return s;
    }

    public static int getIntProperty(String property) {
        Configuration.checkInit();
        String value = Configuration.getProperty(property);
        return Parser.parseInt(value);
    }

    public static boolean getBooleanProperty(String property) {
        Configuration.checkInit();
        String value = Configuration.getProperty(property);
        return Parser.parseInt(value) == 1;
    }

    public static void setProperty(String property, String value) {
        Configuration.checkInit();
        properties.setProperty(property, value);
    }

    public static void saveProperties() {
        Configuration.notifyConfigurationObservers();
        try {
            FileOutputStream outStream = new FileOutputStream("JGPSTrackEdit.properties");
            properties.store(outStream, "JGPSTrackEdit.properties");
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double getDoubleProperty(String property) {
        Configuration.checkInit();
        String value = Configuration.getProperty(property);
        return Parser.parseDouble(value);
    }

    public static double getHourProperty(String property) {
        Configuration.checkInit();
        String value = Configuration.getProperty(property);
        return Parser.parseTime(value);
    }
}

