/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.gpsies;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jgpstrackedit.gpsies.GPSiesTrackDescription;

public class GPSiesResult
extends AbstractTableModel {
    private ArrayList<GPSiesTrackDescription> tracks = new ArrayList();

    public void add(GPSiesTrackDescription track) {
        this.tracks.add(track);
    }

    public GPSiesTrackDescription get(int index) {
        return this.tracks.get(index);
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.tracks.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        GPSiesTrackDescription track = this.tracks.get(row);
        switch (column) {
            case 0: {
                return track.getTitle();
            }
            case 1: {
                String desc = track.getDescription() != null ? track.getDescription() : "";
                return desc;
            }
            case 2: {
                return track.getTrackLengthAsString();
            }
            case 3: {
                return track.getMinAltitude();
            }
            case 4: {
                return track.getMaxAltitude();
            }
            case 5: {
                return track.getTotalAscent();
            }
            case 6: {
                return track.getTotalDescent();
            }
        }
        return "unknown";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Description";
            }
            case 2: {
                return "Length [km]";
            }
            case 3: {
                return "Lowest [m]";
            }
            case 4: {
                return "Highest [m]";
            }
            case 5: {
                return "Ascent [m]";
            }
            case 6: {
                return "Descent [m]";
            }
        }
        return "unknown";
    }
}

