/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.gpsies;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jgpstrackedit.config.SystemConfig;
import jgpstrackedit.data.Track;
import jgpstrackedit.trackfile.kml.KMLWriter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class GPSiesUpLoad {
    private static final String UPLOAD_URL = "http://www.gpsies.com/upload.do";
    private static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    private static final String CHARSET_DEFAULT = "UTF-8";

    public boolean checkUploadable(Track track) {
        return track.getName() != null && !track.getName().startsWith("test") && track.getLength() > 0.25;
    }

    public void saveTempKML(String trackName, Track track) {
        KMLWriter kmlWriter = new KMLWriter();
        File file = new File("gpsiesupload");
        file.mkdirs();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getFileName(trackName)))));
            kmlWriter.print(track, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int uploadFile(String filename, String trackTypes, File importFile, String username, String password) throws HttpException, IOException {
        int result = -1;
        if (username != null && password != null && importFile.exists()) {
            PostMethod postMethod = new PostMethod(UPLOAD_URL);
            postMethod.addRequestHeader("Accept-Language", "de-de");
            postMethod.addRequestHeader("User-Agent", "JGPSTrackEdit (" + importFile + ")");
            String validationString = String.valueOf(username) + "|" + DigestUtils.md5Hex(password);
            String encryptedString = new String(Base64.encodeBase64(validationString.getBytes()));
            Part[] parts = new Part[]{new StringPart("device", "JGPSTrackEdit"), new StringPart("authenticateHash", encryptedString), new StringPart("trackTypes", trackTypes), new StringPart("filename", filename), new StringPart("uploadButton", "speichern"), new FilePart("formFile", importFile, OCTET_STREAM_CONTENT_TYPE, CHARSET_DEFAULT)};
            postMethod.setRequestEntity(new MultipartRequestEntity(parts, postMethod.getParams()));
            HttpClient httpclient = new HttpClient();
            httpclient.getParams().setParameter("Content-type", "text/html;charset=UTF-8");
            httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            result = httpclient.executeMethod(postMethod);
        }
        return result;
    }

    public String getFileName(String trackName) {
        return "gpsiesupload" + SystemConfig.dirSeparator() + trackName + ".kml";
    }
}

