/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tilehandler;

import java.util.LinkedList;
import java.util.concurrent.PriorityBlockingQueue;
import jgpstrackedit.map.tilehandler.AbstractDiskTileHandler;
import jgpstrackedit.map.tilehandler.AbstractTileCommand;
import jgpstrackedit.map.tilehandler.TileLoadObserver;
import jgpstrackedit.map.util.TileNumber;

public abstract class AbstractTileLoader
extends AbstractDiskTileHandler {
    private LinkedList<TileLoadObserver> tileLoadObservers = new LinkedList();

    public AbstractTileLoader() {
        this.setCommandQueue(new PriorityBlockingQueue<AbstractTileCommand>());
    }

    public LinkedList<TileLoadObserver> getTileLoadObservers() {
        return this.tileLoadObservers;
    }

    public synchronized void addTileLoadObserver(TileLoadObserver tileLoadObserver) {
        this.tileLoadObservers.add(tileLoadObserver);
    }

    public synchronized void removeTileLoadObserver(TileLoadObserver tileLoadObserver) {
        this.tileLoadObservers.remove(tileLoadObserver);
    }

    protected abstract void loadTile(TileNumber var1, int var2);

    public void loadTile(TileNumber tileNumber) {
        this.loadTile(tileNumber, 1);
    }

    public void loadTileInBackground(TileNumber tileNumber) {
        this.loadTile(tileNumber, 0);
    }
}

