/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import jgpstrackedit.control.UIController;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.data.util.TourPlaner;
import jgpstrackedit.util.Parser;

public class AltitudeProfilePanel
extends JPanel
implements TrackObserver,
MouseMotionListener,
MouseListener {
    private Track track = null;
    private Point selectedPoint = null;
    private boolean showDayTourMarkers = false;
    private List<Point> markers = null;
    private static final int ALT_WIDTH = 35;
    private static final int LENGTH_HEIGHT = 15;
    private static final int BORDER_HEIGHT = 14;
    private int mouseX = 0;
    private int mouseY = 0;

    public boolean isShowDayTourMarkers() {
        return this.showDayTourMarkers;
    }

    public void setShowDayTourMarkers(boolean showDayTourMarkers) {
        this.showDayTourMarkers = showDayTourMarkers;
        this.repaint();
    }

    public void setSelectedPoint(Point selectedPoint) {
        this.selectedPoint = selectedPoint;
        this.repaint();
    }

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        if (this.track != null) {
            this.track.removeTrackObserver(this);
        }
        this.track = track;
        this.track.addTrackObserver(this);
        this.track.getLength(true);
        this.repaint();
    }

    public AltitudeProfilePanel() {
        this.setPreferredSize(new Dimension(200, 100));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.track != null) {
            double trackLength = this.track.getLength();
            double maxElevation = this.track.getHighestElevation();
            double minElevation = this.track.getLowestElevation();
            double altitudeDifference = maxElevation - minElevation;
            double scaleUnit = this.altitudeScaleUnit(altitudeDifference);
            double scaleMinAltitude = this.calcScaleMinAltitude(minElevation, scaleUnit);
            double scaleMaxAltitude = this.calcScaleMaxAltitude(maxElevation, scaleUnit);
            double scaleAltitudeDifference = scaleMaxAltitude - scaleMinAltitude;
            double scaleUnitLength = this.lengthScaleUnit(trackLength);
            int width = this.getWidth() - 35;
            int height = this.getHeight() - 14 - 15;
            g2D.setColor(Color.LIGHT_GRAY);
            double alt = scaleMinAltitude;
            while (alt < scaleMaxAltitude + scaleUnit) {
                g2D.drawLine(0, height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14, this.getWidth(), height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14);
                g2D.drawString(Parser.formatAltProfile(alt), 2, height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 12);
                alt += scaleUnit;
            }
            double length = 0.0;
            while (length < trackLength) {
                g2D.drawLine((int)(length / trackLength * (double)width) + 35, 0, (int)(length / trackLength * (double)width) + 35, this.getHeight() - 15);
                g2D.drawString(Parser.formatLengthProfile(length), (int)(length / trackLength * (double)width) + 35 - 4, this.getHeight() - 15 + 11);
                length += scaleUnitLength;
            }
            g2D.drawString("m/km", 1, this.getHeight() - 15 + 11);
            g2D.setColor(Color.BLACK);
            g2D.drawLine(35, 0, 35, this.getHeight() - 15);
            g2D.drawLine(35, this.getHeight() - 15, this.getWidth(), this.getHeight() - 15);
            g2D.setColor(Color.RED);
            ArrayList<Point> points = this.track.getPoints();
            Point firstPoint = this.track.getFirstPoint();
            double distance = 0.0;
            if (this.isShowDayTourMarkers()) {
                this.markers = new TourPlaner(this.track).dayTourMarkers();
            }
            int i = 1;
            while (i < points.size()) {
                Point secondPoint = points.get(i);
                double delta = firstPoint.distance(secondPoint);
                g2D.drawLine((int)(distance / trackLength * (double)width) + 35, height - 1 - (int)((firstPoint.getElevation() - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14, (int)((distance + delta) / trackLength * (double)width + 35.0), height - 1 - (int)((secondPoint.getElevation() - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14);
                if (this.isShowDayTourMarkers()) {
                    for (Point marker : this.markers) {
                        if (!firstPoint.equals(marker)) continue;
                        g2D.setColor(Color.WHITE);
                        g2D.fillRect((int)(distance / trackLength * (double)width) - 4, this.getHeight() - 14, 35, 14);
                        g2D.fillRect((int)(distance / trackLength * (double)width) - 4, 0, 35, 13);
                        g2D.setColor(Color.BLUE);
                        g2D.drawString(Parser.formatLengthProfile(firstPoint.getLength()), (int)(distance / trackLength * (double)width), this.getHeight() - 4);
                        g2D.drawString(Parser.formatAltProfile(firstPoint.getElevation()), (int)(distance / trackLength * (double)width) + 2, 10);
                        g2D.drawLine((int)(distance / trackLength * (double)width) + 35, 0, (int)(distance / trackLength * (double)width) + 35, this.getHeight());
                        g2D.setColor(Color.RED);
                    }
                }
                if (this.selectedPoint == firstPoint) {
                    g2D.setColor(Color.WHITE);
                    g2D.fillRect((int)(distance / trackLength * (double)width) - 4, this.getHeight() - 14, 35, 14);
                    g2D.fillRect((int)(distance / trackLength * (double)width) - 4, 0, 35, 13);
                    g2D.setColor(Color.GREEN);
                    g2D.drawString(Parser.formatLengthProfile(firstPoint.getLength()), (int)(distance / trackLength * (double)width), this.getHeight() - 4);
                    g2D.drawString(Parser.formatAltProfile(firstPoint.getElevation()), (int)(distance / trackLength * (double)width) + 2, 10);
                    g2D.drawLine((int)(distance / trackLength * (double)width) + 35, 0, (int)(distance / trackLength * (double)width) + 35, this.getHeight());
                    g2D.setColor(Color.RED);
                }
                distance += delta;
                firstPoint = secondPoint;
                ++i;
            }
            if (this.mouseX > 35) {
                g2D.setColor(Color.WHITE);
                g2D.fillRect(this.mouseX - 35 - 1, this.getHeight() - 14, 35, 14);
                g2D.fillRect(this.mouseX - 35 - 1, 0, 35, 13);
                g2D.setColor(Color.MAGENTA);
                g2D.drawLine(this.mouseX, 0, this.mouseX, this.getHeight());
                double lengthAtCursor = trackLength * (double)(this.mouseX - 35) / (double)width;
                g2D.drawString(Parser.formatLengthProfile(lengthAtCursor), this.mouseX - 35 + 3, this.getHeight() - 4);
                g2D.drawString(Parser.formatAltProfile(this.track.getPoint(lengthAtCursor).getElevation()), this.mouseX - 35 + 3, 10);
            }
        }
    }

    @Override
    public void trackModified(Track track) {
        if (this.track.equals(track)) {
            this.repaint();
        }
    }

    public double altitudeScaleUnit(double altitudeDifference) {
        double[] scaleUnits = new double[]{1.0, 2.5, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0};
        int i = 0;
        while (i < scaleUnits.length) {
            if (4.0 * scaleUnits[i] > altitudeDifference) {
                return scaleUnits[i];
            }
            ++i;
        }
        return 1000.0;
    }

    public double lengthScaleUnit(double length) {
        double[] scaleUnits = new double[]{0.1, 0.2, 0.5, 1.0, 2.5, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0};
        int i = 0;
        while (i < scaleUnits.length) {
            if (7.0 * scaleUnits[i] > length) {
                return scaleUnits[i];
            }
            ++i;
        }
        return 5000.0;
    }

    public double calcScaleMinAltitude(double minAltitude, double scaleUnit) {
        return Math.floor(minAltitude / scaleUnit) * scaleUnit;
    }

    public double calcScaleMaxAltitude(double maxAltitude, double scaleUnit) {
        return Math.ceil(maxAltitude / scaleUnit) * scaleUnit;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        this.paint(graphics2D);
        return image;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        double trackLength = this.track.getLength();
        double lengthAtCursor = trackLength * (double)(this.mouseX - 35) / (double)(this.getWidth() - 35);
        UIController.getUIController().selectPoint(this.track, this.track.getPoint(lengthAtCursor), true);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.mouseX = 0;
        this.mouseY = 0;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.mouseX = 0;
        this.mouseY = 0;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

