/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jgpstrackedit.data.DBObserver;
import jgpstrackedit.data.Database;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.view.TrackView;
import jgpstrackedit.view.ZoomObserver;

public class TracksView
implements DBObserver {
    private Database db;
    private Point leftUpperBoundary = null;
    private Point rightLowerBoundary = null;
    private List<TrackView> tracksView;
    private ArrayList<ZoomObserver> zoomObservers = new ArrayList();

    public TracksView(Database db) {
        this.db = db;
        db.addDBObserver(this);
        this.tracksView = new ArrayList<TrackView>();
    }

    public List<TrackView> getTracksView() {
        return this.tracksView;
    }

    public Point getLeftUpperBoundary() {
        return this.leftUpperBoundary;
    }

    public void setLeftUpperBoundary(Point leftUpperBoundary) {
        this.leftUpperBoundary = leftUpperBoundary;
    }

    public Point getRightLowerBoundary() {
        return this.rightLowerBoundary;
    }

    public void setRightLowerBoundary(Point rightLowerBoundary) {
        this.rightLowerBoundary = rightLowerBoundary;
    }

    protected void createTrackViews() {
        this.tracksView = new LinkedList<TrackView>();
        for (Track track : this.db.getTracks()) {
            TrackView trackView = new TrackView(track);
            this.tracksView.add(trackView);
        }
    }

    public void setView(Point leftUpperBoundary, Point rightLowerBoundary) {
        Point selectedPoint = null;
        TrackView selectedTrackView = this.getSelectedTrackView();
        if (selectedTrackView != null) {
            selectedPoint = selectedTrackView.getSelectedPoint();
        }
        Track selectedTrack = null;
        if (selectedTrackView != null) {
            selectedTrack = this.getSelectedTrackView().getTrack();
        }
        this.createTrackViews();
        for (TrackView trackView : this.tracksView) {
            trackView.setView(leftUpperBoundary, rightLowerBoundary);
        }
        if (selectedTrack != null) {
            this.setSelectedTrack(selectedTrack);
            if (selectedPoint != null) {
                this.setSelectedPoint(selectedPoint);
            }
        }
    }

    @Override
    public void dbModified() {
        this.notifyZoomObservers(this.db.getLeftUpperBoundary(), this.db.getRightLowerBoundary());
    }

    public void addZoomObserver(ZoomObserver observer) {
        this.zoomObservers.add(observer);
    }

    public void removeZoomObserver(ZoomObserver observer) {
        this.zoomObservers.remove(observer);
    }

    protected void notifyZoomObservers(Point leftUpperBoundary, Point rightLowerBoundary) {
        for (ZoomObserver observer : this.zoomObservers) {
            observer.modifiedZoom(null, null, false);
        }
    }

    public void setSelectedTrack(Track track) {
        for (TrackView trackView : this.tracksView) {
            trackView.setSelected(track);
        }
    }

    public TrackView getSelectedTrackView() {
        for (TrackView trackView : this.tracksView) {
            if (!trackView.isSelected()) continue;
            return trackView;
        }
        return null;
    }

    public void setSelectedPoint(Point point) {
        for (TrackView trackView : this.tracksView) {
            if (!trackView.isSelected()) continue;
            trackView.setSelectedPoint(point);
        }
    }
}

