/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import jpass.ui.GeneratePasswordDialog;
import jpass.ui.JPassFrame;
import jpass.ui.MessageDialog;
import jpass.ui.TextComponentFactory;
import jpass.util.SpringUtilities;
import jpass.util.StringUtils;
import jpass.xml.bind.Entry;

public class EntryDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8551022862532925078L;
    private static final char NULL_ECHO = '\u0000';
    private JPanel fieldPanel;
    private JPanel notesPanel;
    private JPanel buttonPanel;
    private JPanel passwordButtonPanel;
    private JTextField titleField;
    private JTextField userField;
    private JPasswordField passwordField;
    private JPasswordField repeatField;
    private JTextField urlField;
    private JTextArea notesField;
    private JButton okButton;
    private JButton cancelButton;
    private JToggleButton showButton;
    private JButton generateButton;
    private final char ORIGINAL_ECHO;
    private Entry formData;
    private boolean newEntry;
    private String originalTitle;

    public EntryDialog(JPassFrame parent, String title, Entry entry, boolean newEntry) {
        super(parent, title, true);
        this.setDefaultCloseOperation(2);
        this.newEntry = newEntry;
        this.formData = null;
        this.fieldPanel = new JPanel();
        this.fieldPanel.add(new JLabel("Title:"));
        this.titleField = TextComponentFactory.newTextField();
        this.fieldPanel.add(this.titleField);
        this.fieldPanel.add(new JLabel("URL:"));
        this.urlField = TextComponentFactory.newTextField();
        this.fieldPanel.add(this.urlField);
        this.fieldPanel.add(new JLabel("User name:"));
        this.userField = TextComponentFactory.newTextField();
        this.fieldPanel.add(this.userField);
        this.fieldPanel.add(new JLabel("Password:"));
        this.passwordField = TextComponentFactory.newPasswordField(true);
        this.ORIGINAL_ECHO = this.passwordField.getEchoChar();
        this.fieldPanel.add(this.passwordField);
        this.fieldPanel.add(new JLabel("Repeat:"));
        this.repeatField = TextComponentFactory.newPasswordField(true);
        this.fieldPanel.add(this.repeatField);
        this.fieldPanel.add(new JLabel(""));
        this.passwordButtonPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.showButton = new JToggleButton("Show", MessageDialog.getIcon("show"));
        this.showButton.setActionCommand("show_button");
        this.showButton.setMnemonic(83);
        this.showButton.addActionListener(this);
        this.passwordButtonPanel.add(this.showButton);
        this.generateButton = new JButton("Generate", MessageDialog.getIcon("generate"));
        this.generateButton.setActionCommand("generate_button");
        this.generateButton.setMnemonic(71);
        this.generateButton.addActionListener(this);
        this.passwordButtonPanel.add(this.generateButton);
        this.fieldPanel.add(this.passwordButtonPanel);
        this.fieldPanel.setLayout(new SpringLayout());
        SpringUtilities.makeCompactGrid(this.fieldPanel, 6, 2, 5, 5, 5, 5);
        this.notesPanel = new JPanel(new BorderLayout(5, 5));
        this.notesPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.notesPanel.add((Component)new JLabel("Notes:"), "North");
        this.notesField = TextComponentFactory.newTextArea();
        this.notesField.setFont(TextComponentFactory.newTextField().getFont());
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        this.notesPanel.add((Component)new JScrollPane(this.notesField), "Center");
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK", MessageDialog.getIcon("accept"));
        this.okButton.setActionCommand("ok_button");
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel", MessageDialog.getIcon("cancel"));
        this.cancelButton.setActionCommand("cancel_button");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.fieldPanel, "North");
        this.getContentPane().add((Component)this.notesPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.fillDialogData(entry);
        this.setSize(420, 400);
        this.setMinimumSize(new Dimension(300, 300));
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GeneratePasswordDialog gpd;
        String generatedPassword;
        String command = e.getActionCommand();
        if ("show_button".equals(command)) {
            this.passwordField.setEchoChar(this.showButton.isSelected() ? (char)'\u0000' : this.ORIGINAL_ECHO);
            this.repeatField.setEchoChar(this.showButton.isSelected() ? (char)'\u0000' : this.ORIGINAL_ECHO);
        } else if ("ok_button".equals(command)) {
            if (this.titleField.getText().trim().isEmpty()) {
                MessageDialog.showWarningMessage(this, "Please fill the title field.");
                return;
            }
            if (!this.checkEntryTitle()) {
                MessageDialog.showWarningMessage(this, "Title is already exists,\nplease enter a different title.");
                return;
            }
            if (!Arrays.equals(this.passwordField.getPassword(), this.repeatField.getPassword())) {
                MessageDialog.showWarningMessage(this, "Password and repeated password are not identical.");
                return;
            }
            this.setFormData(this.fetchDialogData());
            this.dispose();
        } else if ("cancel_button".equals(command)) {
            this.dispose();
        } else if ("generate_button".equals(command) && (generatedPassword = (gpd = new GeneratePasswordDialog(this)).getGeneratedPassword()) != null && !generatedPassword.isEmpty()) {
            this.passwordField.setText(generatedPassword);
            this.repeatField.setText(generatedPassword);
        }
    }

    private void fillDialogData(Entry entry) {
        if (entry == null) {
            return;
        }
        this.originalTitle = entry.getTitle() == null ? "" : entry.getTitle();
        this.titleField.setText(this.originalTitle + (this.newEntry ? " (copy)" : ""));
        this.userField.setText(entry.getUser() == null ? "" : entry.getUser());
        this.passwordField.setText(entry.getPassword() == null ? "" : entry.getPassword());
        this.repeatField.setText(entry.getPassword() == null ? "" : entry.getPassword());
        this.urlField.setText(entry.getUrl() == null ? "" : entry.getUrl());
        this.notesField.setText(entry.getNotes() == null ? "" : entry.getNotes());
        this.notesField.setCaretPosition(0);
    }

    private Entry fetchDialogData() {
        Entry entry = new Entry();
        String title = StringUtils.stripNonValidXMLCharacters(this.titleField.getText());
        String user = StringUtils.stripNonValidXMLCharacters(this.userField.getText());
        String password = StringUtils.stripNonValidXMLCharacters(String.valueOf(this.passwordField.getPassword()));
        String url = StringUtils.stripNonValidXMLCharacters(this.urlField.getText());
        String notes = StringUtils.stripNonValidXMLCharacters(this.notesField.getText());
        entry.setTitle(title == null || title.isEmpty() ? null : title);
        entry.setUser(user == null || user.isEmpty() ? null : user);
        entry.setPassword(password == null || password.isEmpty() ? null : password);
        entry.setUrl(url == null || url.isEmpty() ? null : url);
        entry.setNotes(notes == null || notes.isEmpty() ? null : notes);
        return entry;
    }

    private void setFormData(Entry formData) {
        this.formData = formData;
    }

    public Entry getFormData() {
        return this.formData;
    }

    private boolean checkEntryTitle() {
        boolean titleIsOk = true;
        JPassFrame parent = JPassFrame.getInstance();
        String currentTitleText = StringUtils.stripNonValidXMLCharacters(this.titleField.getText());
        if (currentTitleText == null) {
            currentTitleText = "";
        }
        if (this.newEntry || !currentTitleText.equalsIgnoreCase(this.originalTitle)) {
            for (Entry entry : parent.getModel().getEntries().getEntry()) {
                if (!currentTitleText.equalsIgnoreCase(entry.getTitle())) continue;
                titleIsOk = false;
                break;
            }
        }
        return titleIsOk;
    }
}

