/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jpass.ui.CopiablePasswordField;
import jpass.ui.action.TextComponentAction;
import jpass.util.ClipboardUtils;

public enum TextComponentActionType {
    CUT("jpass.text.cut_action", new TextComponentAction("Cut", KeyStroke.getKeyStroke(88, 2), 84){
        private static final long serialVersionUID = 6463843410774724700L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (this.isEnabled(component)) {
                try {
                    ClipboardUtils.setClipboardContent(component.getSelectedText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                component.replaceSelection("");
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            boolean copyEnabled = true;
            if (component instanceof CopiablePasswordField) {
                copyEnabled = ((CopiablePasswordField)component).isCopyEnabled();
            }
            return component != null && copyEnabled && component.isEnabled() && component.isEditable() && component.getSelectedText() != null;
        }
    }),
    COPY("jpass.text.copy_action", new TextComponentAction("Copy", KeyStroke.getKeyStroke(67, 2), 67){
        private static final long serialVersionUID = 8502265220762730908L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (this.isEnabled(component)) {
                try {
                    ClipboardUtils.setClipboardContent(component.getSelectedText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            boolean copyEnabled = true;
            if (component instanceof CopiablePasswordField) {
                copyEnabled = ((CopiablePasswordField)component).isCopyEnabled();
            }
            return component != null && copyEnabled && component.isEnabled() && component.getSelectedText() != null;
        }
    }),
    PASTE("jpass.text.paste_action", new TextComponentAction("Paste", KeyStroke.getKeyStroke(86, 2), 80){
        private static final long serialVersionUID = -4089879595174370487L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (this.isEnabled(component)) {
                component.replaceSelection(ClipboardUtils.getClipboardContent());
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            return component != null && component.isEnabled() && component.isEditable() && ClipboardUtils.getClipboardContent() != null;
        }
    }),
    DELETE("jpass.text.delete_action", new TextComponentAction("Delete", KeyStroke.getKeyStroke(127, 0), 68){
        private static final long serialVersionUID = 1227622869347781706L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component != null && component.isEnabled() && component.isEditable()) {
                try {
                    Document doc = component.getDocument();
                    Caret caret = component.getCaret();
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    if (dot != mark) {
                        doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    } else if (dot < doc.getLength()) {
                        int delChars = 1;
                        if (dot < doc.getLength() - 1) {
                            String dotChars = doc.getText(dot, 2);
                            char c0 = dotChars.charAt(0);
                            char c1 = dotChars.charAt(1);
                            if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                                delChars = 2;
                            }
                        }
                        doc.remove(dot, delChars);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            return component != null && component.isEnabled() && component.isEditable() && component.getSelectedText() != null;
        }
    }),
    CLEAR_ALL("jpass.text.clear_all_action", new TextComponentAction("Clear All", null, 76){
        private static final long serialVersionUID = 5810788894068735542L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (this.isEnabled(component)) {
                component.selectAll();
                component.replaceSelection("");
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            boolean result = component instanceof CopiablePasswordField ? component.isEnabled() && component.isEditable() && ((CopiablePasswordField)component).getPassword() != null && ((CopiablePasswordField)component).getPassword().length > 0 : component != null && component.isEnabled() && component.isEditable() && component.getText() != null && !component.getText().isEmpty();
            return result;
        }
    }),
    SELECT_ALL("jpass.text.select_all_action", new TextComponentAction("Select All", KeyStroke.getKeyStroke(65, 2), 65){
        private static final long serialVersionUID = 7236761124177884500L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (this.isEnabled(component)) {
                component.selectAll();
            }
        }

        @Override
        public boolean isEnabled(JTextComponent component) {
            boolean result = component instanceof CopiablePasswordField ? component.isEnabled() && ((CopiablePasswordField)component).getPassword() != null && ((CopiablePasswordField)component).getPassword().length > 0 : component != null && component.isEnabled() && component.getText() != null && !component.getText().isEmpty();
            return result;
        }
    });

    private final String name;
    private final TextComponentAction action;

    private TextComponentActionType(String name, TextComponentAction action) {
        this.name = name;
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public TextComponentAction getAction() {
        return this.action;
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.action.getValue("AcceleratorKey");
    }

    public static final void bindAllActions(JTextComponent component) {
        ActionMap actionMap = component.getActionMap();
        InputMap inputMap = component.getInputMap();
        for (TextComponentActionType type : TextComponentActionType.values()) {
            actionMap.put(type.getName(), type.getAction());
            KeyStroke acc = type.getAccelerator();
            if (acc == null) continue;
            inputMap.put(type.getAccelerator(), type.getName());
        }
    }
}

