/*
 * Decompiled with CFR 0.152.
 */
package shared.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class JModalDialog
extends JDialog {
    private boolean m_bOk = false;
    private JPanel m_okCancelPanel;
    private JFrame m_frame;
    private AbstractAction m_cancelAction;
    private AbstractAction m_applyAction;

    public JModalDialog(JFrame frame, String caption, String okStr, String cancelStr, String applyStr, int topSpace) {
        super(frame, caption, true);
        this.doInit(frame, caption, okStr, cancelStr, applyStr, topSpace);
    }

    public JModalDialog(JFrame frame, String caption, String okStr, String cancelStr, int topSpace) {
        super(frame, caption, true);
        this.doInit(frame, caption, okStr, cancelStr, null, topSpace);
    }

    public JModalDialog(JFrame frame, String caption, String okStr, String cancelStr, String applyStr) {
        super(frame, caption, true);
        this.doInit(frame, caption, okStr, cancelStr, applyStr, 10);
    }

    public JModalDialog(JFrame frame, String caption, String okStr, String cancelStr) {
        super(frame, caption, true);
        this.doInit(frame, caption, okStr, cancelStr, null, 10);
    }

    protected void doApply() {
    }

    protected void doInit(JFrame frame, String caption, String okStr, String cancelStr, String applyStr, int topSpace) {
        JButton ok;
        Dimension dim;
        this.m_frame = frame;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.m_okCancelPanel = new JPanel();
        this.m_okCancelPanel.setLayout(new BoxLayout(this.m_okCancelPanel, 0));
        this.m_okCancelPanel.setBorder(BorderFactory.createEmptyBorder(topSpace, 0, 10, 10));
        this.m_okCancelPanel.add(Box.createHorizontalGlue());
        if (applyStr != null) {
            JButton apply = new JButton(applyStr);
            this.m_applyAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ev) {
                    JModalDialog.this.doApply();
                }
            };
            apply.addActionListener(this.m_applyAction);
            dim = apply.getPreferredSize();
            apply.setPreferredSize(new Dimension(100, (int)dim.getHeight()));
            this.m_okCancelPanel.add(apply);
            this.m_okCancelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        if (okStr != null && cancelStr != null) {
            ok = new JButton(okStr);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (JModalDialog.this.doGetData()) {
                        JModalDialog.this.m_bOk = true;
                        JModalDialog.this.dispose();
                    }
                }
            });
            this.getRootPane().setDefaultButton(ok);
            dim = ok.getPreferredSize();
            ok.setPreferredSize(new Dimension(100, (int)dim.getHeight()));
            this.m_okCancelPanel.add(ok);
            this.m_okCancelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton cancel = new JButton(cancelStr);
            this.m_cancelAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ev) {
                    JModalDialog.this.dispose();
                }
            };
            cancel.addActionListener(this.m_cancelAction);
            cancel.setPreferredSize(ok.getPreferredSize());
            this.m_okCancelPanel.add(cancel);
            InputMap inputMap = this.getRootPane().getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", this.m_cancelAction);
        } else if (okStr != null) {
            ok = new JButton(okStr);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (JModalDialog.this.doGetData()) {
                        JModalDialog.this.m_bOk = true;
                        JModalDialog.this.dispose();
                    }
                }
            });
            this.getRootPane().setDefaultButton(ok);
            dim = ok.getPreferredSize();
            ok.setPreferredSize(new Dimension(100, (int)dim.getHeight()));
            this.m_okCancelPanel.add(ok);
        } else if (cancelStr != null) {
            JButton cancel = new JButton(cancelStr);
            this.m_cancelAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ev) {
                    JModalDialog.this.dispose();
                }
            };
            cancel.addActionListener(this.m_cancelAction);
            dim = cancel.getPreferredSize();
            cancel.setPreferredSize(new Dimension(100, (int)dim.getHeight()));
            this.m_okCancelPanel.add(cancel);
            InputMap inputMap = this.getRootPane().getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", this.m_cancelAction);
        }
        contentPane.add((Component)this.m_okCancelPanel, "South");
        this.pack();
    }

    public void addCtrlPanel(JPanel panel) {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "Center");
        if (this.m_frame != null) {
            this.setLocationRelativeTo(this.m_frame);
        }
        this.pack();
    }

    public boolean doModal() {
        this.doInit();
        this.setVisible(true);
        return this.m_bOk;
    }

    protected abstract boolean doGetData();

    protected abstract void doInit();
}

