/*
 * Decompiled with CFR 0.152.
 */
package shared.jinfohelper;

import java.util.Enumeration;
import java.util.Properties;
import shared.files.JPathHelper;

public class JInfoHelper {
    public static String getJavaInfo(int details) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Java version: ");
        strBuilder.append(System.getProperty("java.version"));
        strBuilder.append("\nJava vendor: ");
        strBuilder.append(System.getProperty("java.vendor"));
        if (details >= 1) {
            strBuilder.append("\nSystem: ");
            strBuilder.append(System.getProperty("os.name"));
            strBuilder.append(" ");
            strBuilder.append(System.getProperty("os.version"));
        }
        if (details >= 2) {
            String[] strArray;
            strBuilder.append("\nJava.home: ");
            strBuilder.append(System.getProperty("java.home"));
            strBuilder.append("\nClasspath: ");
            for (String str : strArray = System.getProperty("java.class.path").split("\\" + System.getProperty("path.separator"))) {
                strBuilder.append("\n" + str);
            }
        }
        if (details >= 3) {
            Properties prop = System.getProperties();
            Enumeration<?> keyEnum = prop.propertyNames();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                strBuilder.append("\n");
                strBuilder.append(key);
                strBuilder.append(": ");
                strBuilder.append(prop.getProperty(key));
            }
        }
        return strBuilder.toString();
    }

    public static String getJavaExecutablePath() {
        String str = System.getProperty("java.home");
        if (str != null) {
            StringBuilder strBuilder = new StringBuilder(str);
            JPathHelper.addSeparator(strBuilder);
            strBuilder.append("bin");
            JPathHelper.addSeparator(strBuilder);
            strBuilder.append("java");
            str = strBuilder.toString();
        } else {
            str = "java";
        }
        return str;
    }
}

