/*
 * Decompiled with CFR 0.152.
 */
package jpasswordgenerator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import jpasswordgenerator.JBrowser;
import jpasswordgenerator.Main;
import shared.browserlaunch.JBrowserLaunch;
import shared.classpathhelper.JClassPathHelper;
import shared.datetimedisplay.JDateTimeDisplay;
import shared.files.JPathHelper;
import shared.jinfohelper.JInfoHelper;
import shared.layout.JGridBagPanel;
import shared.numberspinner.JNumberSpinner;
import shared.popupmenu.JStatusMenu;
import shared.popupmenu.JStatusMenuItem;
import shared.popupmenu.JStatusRadioButtonMenuItem;
import shared.statusbar.JStatusBar;

public class JMainFrame
extends JFrame {
    private JCheckBox[] m_setCheckBox = new JCheckBox[6];
    private JTextField[] m_setTextField = new JTextField[6];
    private JButton[] m_resetButton = new JButton[6];
    private JNumberSpinner m_spinnerMin;
    private JNumberSpinner m_spinnerMax;
    private JTextField m_pass;
    private JMenuBar m_menuBar;
    private JStatusBar m_statusBar;
    private JDateTimeDisplay m_dateTimeDisplay;
    private static final String[] m_homepage = new String[]{"http://jpasswordgen.sourceforge.net/"};

    public JMainFrame() {
        super("");
        this.setIconImage(Main.m_icon16.getImage());
        this.setTitle(Main.getString("caption"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JMainFrame.this.doSaveSettings();
            }
        });
        this.m_menuBar = new JMenuBar();
        this.setJMenuBar(this.m_menuBar);
        this.m_statusBar = new JStatusBar(Main.getString("welcome"));
        this.m_dateTimeDisplay = new JDateTimeDisplay();
        this.m_dateTimeDisplay.setTimeFormat(2);
        this.m_dateTimeDisplay.setDateFormat(1);
        this.m_dateTimeDisplay.setSeparator(" - ");
        JStatusMenu jStatusMenu = new JStatusMenu(Main.getString("menu_extra"), this.m_statusBar);
        final JMenu jMenu = new JMenu(Main.getString("menu_lookandfeel"));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        boolean bl = false;
        for (UIManager.LookAndFeelInfo object2 : lookAndFeelInfoArray) {
            JStatusRadioButtonMenuItem jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(object2.getName(), String.format(Main.getString("statusbar_menu_extra_lf_help"), object2.getName()), this.m_statusBar);
            jStatusRadioButtonMenuItem.setActionCommand(object2.getClassName());
            jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Main.m_settings.setLookAndFeel(actionEvent.getActionCommand());
                        int n = jMenu.getItemCount();
                        for (int i = 0; i < n; ++i) {
                            JStatusRadioButtonMenuItem jStatusRadioButtonMenuItem = (JStatusRadioButtonMenuItem)jMenu.getItem(i);
                            jStatusRadioButtonMenuItem.setSelected(jStatusRadioButtonMenuItem.getActionCommand().equals(actionEvent.getActionCommand()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (JOptionPane.showConfirmDialog(Main.m_mainFrame, Main.m_settings.getResBundle().getString("lookandfeel_restart_ask").replace("\\n", "\n"), Main.getMessageBoxCaption(), 0, 3) == 0) {
                        try {
                            String string = JClassPathHelper.getClassPath(this, true);
                            if (string != null) {
                                JMainFrame.this.doSaveSettings();
                                JMainFrame.this.setVisible(false);
                                string = JPathHelper.addSeparator(string);
                                string = string + "jstart.jar";
                                String[] stringArray = new String[]{JInfoHelper.getJavaExecutablePath(), "-jar", string};
                                if (Main.m_settings.isDebug()) {
                                    System.err.println(stringArray[0]);
                                    System.err.println(string);
                                }
                                Runtime.getRuntime().exec(stringArray);
                                System.exit(0);
                            }
                        }
                        catch (Exception exception) {
                            JMainFrame.this.setVisible(true);
                            System.err.println(exception);
                        }
                    }
                }
            });
            jStatusRadioButtonMenuItem.setSelected(Main.m_settings.getLookAndFeel().equals(object2.getClassName()));
            jMenu.add(jStatusRadioButtonMenuItem);
        }
        jStatusMenu.add(jMenu);
        this.m_menuBar.add(jStatusMenu);
        jStatusMenu = new JStatusMenu(Main.getString("menu_help"), this.m_statusBar);
        Object object3 = new JStatusMenuItem(Main.getString("menu_help_help"), Main.getString("statusbar_menu_help_help_help"), this.m_statusBar);
        ((JMenuItem)object3).setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jStatusMenu.add((JMenuItem)object3);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBrowser jBrowser = new JBrowser(Main.m_mainFrame, this.getClass().getResource(Main.getString("helpfile")));
                jBrowser.setVisible(true);
            }
        });
        object3 = new JStatusMenuItem(Main.getString("menu_help_about"), Main.getString("statusbar_menu_help_about_help"), this.m_statusBar);
        jStatusMenu.add((JMenuItem)object3);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Author: Reiner Pr\u00f6ls\nVersion: 1.1\nCopyright \u00a9 2006-2009 by Reiner Pr\u00f6ls\nLicense: GPL");
                stringBuilder.append("\n\n");
                stringBuilder.append("Homepage:\n");
                stringBuilder.append(m_homepage[0]);
                stringBuilder.append("\n\n");
                stringBuilder.append(JInfoHelper.getJavaInfo(Main.m_settings.isDebug() ? 2 : 1));
                if (Main.m_settings.isDebug()) {
                    stringBuilder.append("\n\nMemory: (total, free, max): " + Runtime.getRuntime().totalMemory() + ", " + Runtime.getRuntime().freeMemory() + ", " + Runtime.getRuntime().maxMemory());
                }
                JOptionPane.showMessageDialog(Main.m_mainFrame, stringBuilder.toString(), Main.getMessageBoxCaption(), -1, Main.m_icon32);
            }
        });
        jStatusMenu.addSeparator();
        object3 = new JStatusMenuItem(Main.getString("menu_help_web"), Main.getString("statusbar_menu_help_web_help"), this.m_statusBar);
        jStatusMenu.add((JMenuItem)object3);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JBrowserLaunch.openURL(m_homepage[0])) {
                    JOptionPane.showMessageDialog(Main.m_mainFrame, String.format(Main.getString("msg_browserlaunch_failed"), m_homepage[0], m_homepage[1]), Main.getMessageBoxCaption(), -1, Main.m_icon32);
                }
            }
        });
        this.m_menuBar.add(jStatusMenu);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        Dimension dimension = new Dimension(230, 20);
        int n = 0;
        int n2 = 0;
        for (int jButton = 0; jButton < 6; ++jButton) {
            this.m_setCheckBox[jButton] = new JCheckBox(Main.getString(String.format("setname_%1$d", jButton + 1)), Main.m_settings.isSet(jButton));
            this.m_setCheckBox[jButton].setToolTipText(Main.getString(String.format("setname_tooltip_%1$d", jButton + 1)));
            final int jPanel = jButton;
            this.m_setCheckBox[jButton].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMainFrame.this.doSetSetState(jPanel, ((JCheckBox)actionEvent.getSource()).isSelected());
                }
            });
            jGridBagPanel.addComponent(this.m_setCheckBox[jButton], n2, n, 17, new Insets(2, 0, 0, 0));
            this.m_resetButton[jButton] = new JButton(Main.getString(String.format("reset", jButton + 1)));
            this.m_resetButton[jButton].setToolTipText(Main.getString(String.format("reset_tooltip_%1$d", jButton + 1)));
            Dimension dimension2 = this.m_resetButton[jButton].getPreferredSize();
            this.m_resetButton[jButton].setDefaultCapable(false);
            this.m_resetButton[jButton].setMargin(new Insets(0, 0, 0, 0));
            this.m_resetButton[jButton].setMinimumSize(new Dimension(45, 20));
            this.m_resetButton[jButton].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMainFrame.this.m_setTextField[jPanel].setText(Main.m_settings.getDefSet(jPanel));
                }
            });
            jGridBagPanel.addComponent(this.m_resetButton[jButton], n2, n, 13, new Insets(2, 0, 0, 7));
            this.m_setTextField[jButton] = new JTextField(Main.m_settings.getSet(jButton), 35);
            this.m_setTextField[jButton].setMinimumSize(dimension);
            this.m_setTextField[jButton].setEnabled(Main.m_settings.isSet(jButton));
            this.m_setTextField[jButton].setToolTipText(Main.getString(String.format("set_tooltip_%1$d", jButton + 1)));
            jGridBagPanel.addComponent(this.m_setTextField[jButton], n2, ++n, 17, new Insets(3, 0, 15, 7));
            ++n;
            if (jButton == 2) {
                ++n2;
                n = 0;
            }
            this.doSetSetState(jButton, Main.m_settings.isSet(jButton));
        }
        jGridBagPanel.addComponent(new JLabel(Main.getString("min")), 0, ++n, 17, new Insets(0, 0, 0, 0));
        jGridBagPanel.addComponent(new JLabel(Main.getString("max")), 1, n, 17, new Insets(0, 0, 0, 0));
        this.m_spinnerMin = new JNumberSpinner(new SpinnerNumberModel(Main.m_settings.getMin(), 0, 30, 1));
        this.m_spinnerMin.setToolTipText(Main.getString("tooltip_min"));
        jGridBagPanel.addComponent(this.m_spinnerMin, 0, ++n, 17, new Insets(0, 0, 15, 7));
        this.m_spinnerMax = new JNumberSpinner(new SpinnerNumberModel(Main.m_settings.getMax(), 0, 30, 1));
        this.m_spinnerMax.setToolTipText(Main.getString("tooltip_max"));
        jGridBagPanel.addComponent(this.m_spinnerMax, 1, n, 17, new Insets(0, 0, 15, 7));
        JButton jButton = new JButton("Create");
        jGridBagPanel.addComponent(jButton, 1, n, 13, new Insets(3, 0, 15, 7));
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.setGuiDataToSettings();
                JMainFrame.this.m_pass.setText(Main.doCreatePassword());
                JMainFrame.this.m_pass.selectAll();
                JMainFrame.this.m_pass.copy();
                JMainFrame.this.m_pass.select(0, 0);
            }
        });
        jButton.setToolTipText(Main.getString("tooltip_create"));
        ++n;
        this.m_pass = new JTextField("");
        this.m_pass.setFont(this.m_pass.getFont().deriveFont(1, Main.m_settings.getPassFontSize()));
        this.m_pass.setHorizontalAlignment(0);
        this.m_pass.setMinimumSize(new Dimension(dimension.width * 2 + 7, 50));
        this.m_pass.setEditable(false);
        this.m_pass.setBorder(new SoftBevelBorder(1));
        this.m_pass.setToolTipText(Main.getString("tooltip_pass"));
        jGridBagPanel.addComponent(this.m_pass, 0, n, 17, new Insets(3, 0, 15, 7), 2, 1);
        container.add((Component)jGridBagPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.m_statusBar, "Center");
        this.m_dateTimeDisplay.setText("XXX");
        jPanel.add((Component)this.m_dateTimeDisplay, "East");
        container.add((Component)jPanel, "South");
        this.setPreferredSize(new Dimension(500, 400));
        this.setResizable(false);
        this.pack();
    }

    private void doSetSetState(int n, boolean bl) {
        this.m_setTextField[n].setEnabled(bl);
        this.m_resetButton[n].setEnabled(bl);
    }

    private void setGuiDataToSettings() {
        for (int i = 0; i < 6; ++i) {
            Main.m_settings.setIsSet(i, this.m_setCheckBox[i].isSelected());
            Main.m_settings.setSet(i, this.m_setTextField[i].getText());
        }
        Main.m_settings.setMin((Integer)this.m_spinnerMin.getValue());
        Main.m_settings.setMax((Integer)this.m_spinnerMax.getValue());
    }

    private void doSaveSettings() {
        this.setGuiDataToSettings();
        Main.m_settings.save(JPathHelper.addSeparator(System.getProperty("user.home")) + "jpasswordgenerator.properties");
    }
}

