/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords;

import java.util.Random;

public class PasswordGenerator {
    public static final int ALPHABETIC = 1;
    public static final int NUMERIC = 2;
    public static final int ALPHABETIC_NUMERIC = 3;
    public static final int ALPHABETIC_NUMERIC_SYMBOLS = 4;
    public static final String ALPHABETS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBERS = "1234567890";
    public static final String SYMBOLS = "-=_+)(*&^%$#@!<>/\\}{[]?.,";
    private Random random;
    private final int length;
    private final int type;

    public PasswordGenerator(int length, int type) {
        this.length = length;
        this.type = type;
        this.random = new Random(System.currentTimeMillis());
    }

    public String generatePassword() {
        String validChars;
        switch (this.type) {
            case 1: {
                validChars = ALPHABETS;
                break;
            }
            case 3: {
                validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                break;
            }
            case 2: {
                validChars = NUMBERS;
                break;
            }
            case 4: {
                validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-=_+)(*&^%$#@!<>/\\}{[]?.,";
                break;
            }
            default: {
                validChars = "";
            }
        }
        char[] password = new char[this.length];
        for (int i = 0; i < password.length; ++i) {
            int charPosition = this.randomInt(validChars.length());
            password[i] = new Character(validChars.charAt(charPosition)).charValue();
        }
        return new String(password);
    }

    private int randomInt(int max) {
        return this.random.nextInt(max);
    }
}

