/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.io.FileEncryptor;
import com.ehsunbehravesh.mypasswords.io.FileEncryptorMessage;
import com.ehsunbehravesh.mypasswords.io.FileLoader;
import com.ehsunbehravesh.mypasswords.io.FileLoaderMessage;
import com.ehsunbehravesh.mypasswords.io.FileSaver;
import com.ehsunbehravesh.mypasswords.io.FileSaverMessage;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class EncryptionDialog
extends JDialog
implements ActionListener,
Observer {
    private JPopupMenu popMessage;
    private JPopupMenu popEncrypted;
    private JMenuItem mniEncryptedCopy;
    private JMenuItem mniTextPaste;
    private JMenuItem mniTextCopy;
    private JMenuItem mniTextSelectAll;
    private JMenuItem mniEncryptedSelectAll;
    private JFrame parent;
    private Byte[] contentOfFile;
    private File largeSourceFile;
    private File largeDestinationFile;
    private JButton btnDecrypt;
    private JButton btnEncrypt;
    private JButton btnOpenLarge;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrolPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JPanel pnlStatus;
    private JProgressBar progressBar;
    private JSplitPane slpMain;
    private JToolBar tlbMain;
    private JToolBar tlbMain2;
    private JTextArea txaEncrypted;
    private JTextArea txaMessage;

    public EncryptionDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.createComponents();
        this.myInitComponents();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.pnlStatus = new JPanel();
        this.progressBar = new JProgressBar();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.tlbMain = new JToolBar();
        this.btnEncrypt = new JButton();
        this.btnDecrypt = new JButton();
        this.slpMain = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.txaEncrypted = new JTextArea();
        this.jScrolPane1 = new JScrollPane();
        this.txaMessage = new JTextArea();
        this.jPanel4 = new JPanel();
        this.tlbMain2 = new JToolBar();
        this.btnOpenLarge = new JButton();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setTitle("Encryptor");
        GroupLayout pnlStatusLayout = new GroupLayout(this.pnlStatus);
        this.pnlStatus.setLayout(pnlStatusLayout);
        pnlStatusLayout.setHorizontalGroup(pnlStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlStatusLayout.createSequentialGroup().addContainerGap().addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        pnlStatusLayout.setVerticalGroup(pnlStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlStatusLayout.createSequentialGroup().addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EncryptionDialog.this.jTabbedPane1KeyPressed(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.tlbMain.setBackground(new Color(255, 255, 255));
        this.tlbMain.setFloatable(false);
        this.tlbMain.setRollover(true);
        this.btnEncrypt.setBackground(new Color(255, 255, 255));
        this.btnEncrypt.setIcon(new ImageIcon(this.getClass().getResource("/com/ehsunbehravesh/mypasswords/resource/lock.png")));
        this.btnEncrypt.setToolTipText("Encrypt");
        this.btnEncrypt.setFocusable(false);
        this.btnEncrypt.setHorizontalTextPosition(0);
        this.btnEncrypt.setVerticalTextPosition(3);
        this.btnEncrypt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncryptionDialog.this.btnEncryptActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnEncrypt);
        this.btnDecrypt.setBackground(new Color(255, 255, 255));
        this.btnDecrypt.setIcon(new ImageIcon(this.getClass().getResource("/com/ehsunbehravesh/mypasswords/resource/unlock.png")));
        this.btnDecrypt.setToolTipText("Decrypt");
        this.btnDecrypt.setFocusable(false);
        this.btnDecrypt.setHorizontalTextPosition(0);
        this.btnDecrypt.setVerticalTextPosition(3);
        this.btnDecrypt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncryptionDialog.this.btnDecryptActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnDecrypt);
        this.jPanel1.add((Component)this.tlbMain, "First");
        this.slpMain.setBackground(new Color(255, 255, 255));
        this.slpMain.setOrientation(0);
        this.slpMain.setResizeWeight(0.5);
        this.txaEncrypted.setColumns(20);
        this.txaEncrypted.setEditable(false);
        this.txaEncrypted.setLineWrap(true);
        this.txaEncrypted.setRows(5);
        this.txaEncrypted.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EncryptionDialog.this.txaEncryptedMouseClicked(evt);
            }
        });
        this.txaEncrypted.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EncryptionDialog.this.txaEncryptedKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.txaEncrypted);
        this.slpMain.setRightComponent(this.jScrollPane2);
        this.txaMessage.setColumns(20);
        this.txaMessage.setLineWrap(true);
        this.txaMessage.setRows(5);
        this.txaMessage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EncryptionDialog.this.txaMessageMouseClicked(evt);
            }
        });
        this.txaMessage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EncryptionDialog.this.txaMessageKeyPressed(evt);
            }
        });
        this.jScrolPane1.setViewportView(this.txaMessage);
        this.slpMain.setLeftComponent(this.jScrolPane1);
        this.jPanel1.add((Component)this.slpMain, "Center");
        this.jTabbedPane1.addTab("Text", this.jPanel1);
        this.tlbMain2.setBackground(new Color(255, 255, 255));
        this.tlbMain2.setFloatable(false);
        this.tlbMain2.setRollover(true);
        this.btnOpenLarge.setBackground(new Color(255, 255, 255));
        this.btnOpenLarge.setIcon(new ImageIcon(this.getClass().getResource("/com/ehsunbehravesh/mypasswords/resource/open.png")));
        this.btnOpenLarge.setToolTipText("Open file");
        this.btnOpenLarge.setFocusable(false);
        this.btnOpenLarge.setHorizontalTextPosition(0);
        this.btnOpenLarge.setVerticalTextPosition(3);
        this.btnOpenLarge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncryptionDialog.this.btnOpenLargeActionPerformed(evt);
            }
        });
        this.tlbMain2.add(this.btnOpenLarge);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tlbMain2, -1, 398, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.tlbMain2, -2, 25, -2).addContainerGap(265, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("File", this.jPanel4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlStatus, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlStatus, -2, -1, -2)));
        this.pack();
    }

    private void btnEncryptActionPerformed(ActionEvent evt) {
        this.encryptText();
    }

    private void btnDecryptActionPerformed(ActionEvent evt) {
        this.decryptText();
    }

    private void txaEncryptedMouseClicked(MouseEvent evt) {
        this.txaEncryptedMouseClick(evt);
    }

    private void txaMessageMouseClicked(MouseEvent evt) {
        this.txaMessageMouseclick(evt);
    }

    private void btnOpenLargeActionPerformed(ActionEvent evt) {
        this.openLargeFile();
    }

    private void jTabbedPane1KeyPressed(KeyEvent evt) {
        this.jTabbedPane1KeyPress(evt);
    }

    private void txaMessageKeyPressed(KeyEvent evt) {
        this.txaMessageKeyPress(evt);
    }

    private void txaEncryptedKeyPressed(KeyEvent evt) {
        this.txaEncryptedKeyPress(evt);
    }

    private void myInitComponents() {
        this.setComponentOrientation(this.parent.getComponentOrientation());
        this.setFont(this.parent.getFont());
        Utils.setCenterOfParent(this.parent, (JDialog)this);
        this.progressBar.setVisible(false);
    }

    private void encryptText() {
        String key = this.getEncryptionKey();
        if (key != null) {
            try {
                String text = this.txaMessage.getText();
                String encrypted = Utils.encrypt(key, text);
                this.txaEncrypted.setText(encrypted);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid encryption key!", "Error", 0);
                Logger.log(ex.getMessage());
            }
        }
    }

    private String getEncryptionKey() {
        ImageIcon icon = new ImageIcon(ResourceLoader.class.getResource("key64.png"));
        String key = (String)JOptionPane.showInputDialog(this, "Enter your encryption key (16 characters): ", "Key", 3, icon, null, null);
        if (key != null) {
            if (key.length() != 16) {
                JOptionPane.showMessageDialog(this, "The key must be 16 characters long!", "Invalid Key", 2);
                return null;
            }
            return key;
        }
        return null;
    }

    private void decryptText() {
        String key = this.getEncryptionKey();
        if (key != null) {
            try {
                String encrypted = this.txaMessage.getText();
                String text = Utils.decrypt(key, encrypted);
                this.txaEncrypted.setText(text);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid encryption key!", "Error", 0);
                Logger.log(ex.getMessage());
            }
        }
    }

    private void createComponents() {
        this.popMessage = new JPopupMenu();
        this.popEncrypted = new JPopupMenu();
        this.mniEncryptedCopy = new JMenuItem("Copy");
        this.mniTextCopy = new JMenuItem("Copy");
        this.mniTextPaste = new JMenuItem("Paste");
        this.mniTextSelectAll = new JMenuItem("Select All");
        this.mniEncryptedSelectAll = new JMenuItem("Select All");
        this.popMessage.add(this.mniTextSelectAll);
        this.popMessage.add(this.mniTextCopy);
        this.popMessage.add(this.mniTextPaste);
        this.popEncrypted.add(this.mniEncryptedSelectAll);
        this.popEncrypted.add(this.mniEncryptedCopy);
        this.mniEncryptedCopy.addActionListener(this);
        this.mniTextPaste.addActionListener(this);
        this.mniTextCopy.addActionListener(this);
        this.mniTextSelectAll.addActionListener(this);
        this.mniEncryptedSelectAll.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.mniTextCopy) {
            String selectedText = this.txaMessage.getSelectedText();
            Utils.setClipboardContents(selectedText, null);
        } else if (source == this.mniEncryptedCopy) {
            String selectedText = this.txaEncrypted.getSelectedText();
            Utils.setClipboardContents(selectedText, null);
        } else if (source == this.mniTextPaste) {
            String textInClipboard = Utils.getClipboardContents();
            if (textInClipboard != null && textInClipboard.length() > 0) {
                this.txaMessage.replaceSelection(textInClipboard);
            }
        } else if (source == this.mniTextSelectAll) {
            this.txaMessage.requestFocus();
            this.txaMessage.selectAll();
        } else if (source == this.mniEncryptedSelectAll) {
            this.txaEncrypted.requestFocus();
            this.txaEncrypted.selectAll();
        }
    }

    private void txaEncryptedMouseClick(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            String selectedText = this.txaEncrypted.getSelectedText();
            this.mniEncryptedCopy.setEnabled(selectedText != null && selectedText.length() > 0);
            this.popEncrypted.show(this.txaEncrypted, evt.getX(), evt.getY());
        }
    }

    private void txaMessageMouseclick(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            String clipboardContent = Utils.getClipboardContents();
            this.mniTextPaste.setEnabled(clipboardContent != null && clipboardContent.length() > 0);
            String selectedText = this.txaMessage.getSelectedText();
            this.mniTextCopy.setEnabled(selectedText != null && selectedText.length() > 0);
            this.popMessage.show(this.jScrolPane1, evt.getX(), evt.getY());
        }
    }

    private void openFile() {
        JFileChooser fileChooser = new JFileChooser();
        int answer = fileChooser.showOpenDialog(this);
        if (answer == 0) {
            File file = null;
            file = fileChooser.getSelectedFile();
            int buffersize = (int)(file.length() / 100L);
            if (buffersize < 1024) {
                buffersize = 1024;
            }
            if (file.length() / 0x100000L > 10L) {
                JOptionPane.showMessageDialog(this, "Files greater than 10MB are not supported! Go to next tab", "Big file", 0);
            } else {
                FileLoader fileLoader = new FileLoader(file, buffersize);
                fileLoader.addObserver(this);
                Thread thread = new Thread(fileLoader);
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum((int)(file.length() / (long)buffersize));
                this.progressBar.setValue(0);
                this.progressBar.setVisible(true);
                this.invalidate();
                this.repaint();
                thread.start();
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FileLoader) {
            FileLoader fileLoader = (FileLoader)o;
            FileLoaderMessage message = (FileLoaderMessage)arg;
            if (message.getMessage() == 1) {
                this.progressBar.setValue(this.progressBar.getValue() + 1);
            } else if (message.getMessage() == 3) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, message.getDescription(), "Error", 0);
            } else if (message.getMessage() == 2) {
                this.progressBar.setVisible(false);
                this.contentOfFile = fileLoader.getContent();
            }
        } else if (o instanceof FileSaver) {
            FileSaver fileSaver = (FileSaver)o;
            FileSaverMessage message = (FileSaverMessage)arg;
            if (message.getMessage() == 1) {
                this.progressBar.setValue(this.progressBar.getValue() + 1);
            } else if (message.getMessage() == 2) {
                JOptionPane.showMessageDialog(this, "Saved successfully!", "Saved", 1);
                this.progressBar.setVisible(false);
            } else if (message.getMessage() == 3) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, message.getDescription(), "Error", 0);
            }
        } else if (o instanceof FileEncryptor) {
            FileEncryptor encryptor = (FileEncryptor)o;
            FileEncryptorMessage message = (FileEncryptorMessage)arg;
            if (message.getMessage() == 1) {
                this.progressBar.setValue(this.progressBar.getValue() + 1);
            } else if (message.getMessage() == 2) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Saved successfully!", "Saved", 1);
            } else if (message.getMessage() == 3) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Error happened in reading file!", "Error", 0);
                Logger.log(message.getDescription());
            } else if (message.getMessage() == 6) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Error happened in writing file!", "Error", 0);
                Logger.log(message.getDescription());
            } else if (message.getMessage() == 4) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Error happened in encryption!", "Error", 0);
                Logger.log(message.getDescription());
            } else if (message.getMessage() == 5) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Error happened in decryption!", "Error", 0);
                Logger.log(message.getDescription());
            } else if (message.getMessage() == 7) {
                this.progressBar.setVisible(false);
                JOptionPane.showMessageDialog(this, "Error happened!", "Error", 0);
                Logger.log(message.getDescription());
            }
        }
    }

    private void saveEncryptFile() {
        JFileChooser fileChooser;
        int answer;
        String key = this.getEncryptionKey();
        if (key != null && (answer = (fileChooser = new JFileChooser()).showSaveDialog(this)) == 0) {
            File file = fileChooser.getSelectedFile();
            boolean fileIsOk = true;
            if (file.exists()) {
                answer = JOptionPane.showConfirmDialog(this, "Do you want to overwrite exisiting file?", "Warning", 0, 2);
                boolean bl = fileIsOk = answer == 0;
            }
            if (fileIsOk) {
                try {
                    byte[] byteText = new byte[this.contentOfFile.length];
                    for (int i = 0; i < byteText.length; ++i) {
                        byteText[i] = this.contentOfFile[i];
                    }
                    byte[] encryptedData = Utils.encrypt(key, byteText);
                    FileSaver fileSaver = new FileSaver(file, encryptedData, 1000);
                    fileSaver.addObserver(this);
                    Thread thread = new Thread(fileSaver);
                    this.progressBar.setValue(0);
                    this.progressBar.setMaximum(encryptedData.length / 1000);
                    this.progressBar.setVisible(true);
                    thread.start();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error occured in encryption!", "Error", 0);
                    Logger.log(ex.getMessage());
                }
            }
        }
    }

    private void saveDecryptFile() {
        JFileChooser fileChooser;
        int answer;
        String key = this.getEncryptionKey();
        if (key != null && (answer = (fileChooser = new JFileChooser()).showSaveDialog(this)) == 0) {
            File file = fileChooser.getSelectedFile();
            boolean fileIsOk = true;
            if (file.exists()) {
                answer = JOptionPane.showConfirmDialog(this, "Do you want to overwrite exisiting file?", "Warning", 0, 2);
                boolean bl = fileIsOk = answer == 0;
            }
            if (fileIsOk) {
                try {
                    byte[] byteText = new byte[this.contentOfFile.length];
                    for (int i = 0; i < byteText.length; ++i) {
                        byteText[i] = this.contentOfFile[i];
                    }
                    byte[] encryptedData = Utils.decrypt(key, byteText);
                    FileSaver fileSaver = new FileSaver(file, encryptedData, 1000);
                    fileSaver.addObserver(this);
                    Thread thread = new Thread(fileSaver);
                    this.progressBar.setValue(0);
                    this.progressBar.setMaximum(encryptedData.length / 1000);
                    this.progressBar.setVisible(true);
                    thread.start();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error occured in decryption!", "Error", 0);
                    Logger.log(ex.getMessage());
                }
            }
        }
    }

    private void openLargeFile() {
        JFileChooser fileChooser = new JFileChooser();
        int answer = fileChooser.showOpenDialog(this);
        if (answer == 0) {
            this.largeSourceFile = fileChooser.getSelectedFile();
            if (this.largeSourceFile.exists()) {
                String strSizeOfFile = "";
                strSizeOfFile = this.largeSourceFile.length() < 1000L ? String.format("%d bytes", this.largeSourceFile.length()) : (this.largeSourceFile.length() < 1000000L ? String.format("%.2f kilobytes", Float.valueOf((float)this.largeSourceFile.length() / 1024.0f)) : (this.largeSourceFile.length() < 1000000000L ? String.format("%.2f megabytes", Float.valueOf((float)this.largeSourceFile.length() / 1048576.0f)) : String.format("%.2f gigabytes", Float.valueOf((float)this.largeSourceFile.length() / 1.0737418E9f))));
                String result = (String)JOptionPane.showInputDialog(this, String.format("<html>Size of your file is <b>%s</b>.<br/>What do you want to do with this file?</html>", strSizeOfFile), "Encryption / Decryption", 3, null, new String[]{"Encrypt", "Decrypt"}, null);
                if (result != null && (answer = fileChooser.showSaveDialog(this)) == 0) {
                    String strKey;
                    this.largeDestinationFile = fileChooser.getSelectedFile();
                    boolean fileIsOk = true;
                    if (this.largeDestinationFile.exists()) {
                        answer = JOptionPane.showConfirmDialog(this, "Do you want to overwrite exisiting file?", "Warning", 0, 2);
                        boolean bl = fileIsOk = answer == 0;
                    }
                    if (fileIsOk && (strKey = this.getEncryptionKey()) != null) {
                        int mode;
                        byte[] key = strKey.getBytes(Charset.forName("UTF8"));
                        int n = result.equalsIgnoreCase("encrypt") ? 1 : (mode = result.equalsIgnoreCase("decrypt") ? 2 : 0);
                        if (mode != 0) {
                            int bufferSize = 0x200000;
                            FileEncryptor fileEncryptor = new FileEncryptor(mode, key, this.largeSourceFile, this.largeDestinationFile, bufferSize);
                            fileEncryptor.addObserver(this);
                            this.progressBar.setValue(0);
                            this.progressBar.setMaximum((int)(this.largeSourceFile.length() / (long)bufferSize));
                            this.progressBar.setVisible(true);
                            Thread thread = new Thread(fileEncryptor);
                            thread.start();
                        }
                    }
                }
            }
        }
    }

    private void jTabbedPane1KeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void txaMessageKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void txaEncryptedKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }
}

