/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.exportimport.XMLImporter;
import com.ehsunbehravesh.mypasswords.gui.MainFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ImportDialog
extends JDialog
implements Observer {
    private XMLImporter importer;
    private JButton btnCancel;
    private JButton btnStart;
    private JCheckBox chkOverWrite;
    private JLabel lblStatus;
    private JLabel lblTitle;
    private JPanel pnlMain;
    private JProgressBar prgImport;

    public ImportDialog(Frame parent, boolean modal, File file, String key, boolean allFieldsAreEncrypted) {
        super(parent, modal);
        this.importer = new XMLImporter(file, key, false, allFieldsAreEncrypted);
        this.initComponents();
        this.myInitComponents();
        Utils.setCenterOfParent((JFrame)this.getParent(), (JDialog)this);
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.btnCancel = new JButton();
        this.lblStatus = new JLabel();
        this.prgImport = new JProgressBar();
        this.lblTitle = new JLabel();
        this.chkOverWrite = new JCheckBox();
        this.btnStart = new JButton();
        this.setDefaultCloseOperation(2);
        this.pnlMain.setBackground(new Color(254, 254, 254));
        this.btnCancel.setFont(new Font("Tahoma", 0, 13));
        this.btnCancel.setText("Cancel");
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.lblStatus.setFont(new Font("Tahoma", 0, 10));
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setText("Import from XML");
        this.chkOverWrite.setBackground(new Color(255, 255, 255));
        this.chkOverWrite.setText("Overwrite existing passwords");
        this.btnStart.setFont(new Font("Tahoma", 0, 13));
        this.btnStart.setText("Start Import");
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportDialog.this.btnStartActionPerformed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlMainLayout.createSequentialGroup().addContainerGap().addComponent(this.btnStart, -2, 116, -2)).addGroup(GroupLayout.Alignment.LEADING, pnlMainLayout.createSequentialGroup().addGap(37, 37, 37).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.prgImport, -2, 379, -2).addGroup(GroupLayout.Alignment.TRAILING, pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkOverWrite).addComponent(this.lblTitle).addComponent(this.lblStatus, -2, 250, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 117, -2))))).addGap(39, 39, 39)));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.lblTitle).addGap(18, 18, 18).addComponent(this.chkOverWrite).addGap(9, 9, 9).addComponent(this.btnStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE).addComponent(this.prgImport, -2, -1, -2).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnCancel).addComponent(this.lblStatus, -2, 29, -2)).addGap(35, 35, 35)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.doImport();
    }

    private void doImport() {
        this.importer.setOverWrite(this.chkOverWrite.isSelected());
        this.btnCancel.setEnabled(true);
        this.btnStart.setEnabled(false);
        this.chkOverWrite.setEnabled(false);
        Thread thread = new Thread(this.importer);
        thread.start();
        Logger.log("Import started: " + this.importer.getFile().getAbsolutePath());
    }

    private void myInitComponents() {
        MainFrame mainFrame = (MainFrame)this.getParent();
        if (mainFrame.getCurrentLanguage() != null) {
            // empty if block
        }
        this.chkOverWrite.requestFocus();
        this.importer.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.toString().equals("init")) {
            this.prgImport.setMinimum(this.importer.getMinProgress());
            this.prgImport.setMaximum(this.importer.getMaxProgress());
            this.prgImport.setValue(this.importer.getProgress());
        } else if (arg.toString().equals("progress")) {
            this.prgImport.setValue(this.importer.getProgress());
            this.lblStatus.setText(this.importer.getProgressPercent() + "%");
            if (this.importer.getProgress() == this.importer.getMaxProgress()) {
                this.btnCancel.setText("Close");
                this.lblStatus.setText(String.format("%s - Passwords: %d, Tags: %d", this.lblStatus.getText(), this.importer.getPasswordsCount(), this.importer.getTagsCount()));
                Logger.log("Import finished: " + this.importer.getFile().getAbsolutePath());
                Logger.log(String.format("PasswordsCount: %d - TagsCount: %d", this.importer.getPasswordsCount(), this.importer.getTagsCount()));
            }
        }
    }
}

