/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class LoginDialog
extends JDialog {
    public static final int LOGIN_SUCCESSFULL = 1;
    public static final int LOGIN_FAILED = 2;
    public static final int LOGIN_CANCELED = 3;
    private static final int ALLOWED_LOGINS = 5;
    private static final int LOCK_INTERVAL = 30;
    private int loginResult;
    private JFileChooser openDialog;
    private int failedLogins;
    private boolean locked;
    private Timer tmrDisplayLock;
    private Timer tmrOpenLock;
    private int remainingSeconds;
    private JButton btnCancel;
    private JButton btnOk;
    private JButton btnRecover;
    private JLabel jLabel1;
    private JLabel lblIcon;
    private JPanel pnlMain;
    private JPasswordField txtPassword;

    public LoginDialog(JFrame parent, boolean modal, boolean centerOfParent) {
        super((Frame)parent, modal);
        this.initComponents();
        this.myInitComponente();
        if (centerOfParent) {
            Utils.setCenterOfParent(parent, (JDialog)this);
        } else {
            this.setCenter();
        }
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.lblIcon = new JLabel();
        this.btnRecover = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoginDialog.this.formWindowClosing(evt);
            }
        });
        this.pnlMain.setBackground(new Color(254, 254, 254));
        this.jLabel1.setText("Please enter your password:");
        this.txtPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.txtPasswordKeyPressed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.btnCancelKeyPressed(evt);
            }
        });
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnOk.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.btnOkKeyPressed(evt);
            }
        });
        this.btnRecover.setText("Login by Recovery File");
        this.btnRecover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.btnRecoverActionPerformed(evt);
            }
        });
        this.btnRecover.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.btnRecoverKeyPressed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlMainLayout.createSequentialGroup().addContainerGap().addComponent(this.lblIcon, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnRecover, GroupLayout.Alignment.LEADING, -1, 220, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, pnlMainLayout.createSequentialGroup().addComponent(this.btnOk, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 42, Short.MAX_VALUE).addComponent(this.btnCancel, -2, 89, -2)).addComponent(this.txtPassword, GroupLayout.Alignment.LEADING, -1, 220, Short.MAX_VALUE)).addGap(37, 37, 37)));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPassword, -2, -1, -2).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel))).addComponent(this.lblIcon, -2, 64, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRecover).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void txtPasswordKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btnOkActionPerformed(null);
        } else if (evt.getKeyCode() == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.loginResult = 3;
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.locked) {
            return;
        }
        try {
            Domain domain = Domain.getInstance();
            String currentPassword = domain.getSetting("password", null);
            currentPassword = currentPassword != null ? currentPassword : "";
            String enteredPassword = new String(this.txtPassword.getPassword());
            enteredPassword = Utils.SHA256(enteredPassword);
            if (currentPassword.equals(enteredPassword)) {
                this.setVisible(false);
                this.dispose();
                this.loginResult = 1;
                domain.setPassword(new String(this.txtPassword.getPassword()));
            } else {
                JOptionPane.showMessageDialog(this, "Incorrect password!", "Warning", 2);
                this.txtPassword.selectAll();
                this.txtPassword.requestFocus();
                String value = domain.getSetting("log_failed_logins", null);
                if (value != null) {
                    int intValue = Integer.parseInt(value);
                    if (intValue < 1000000) {
                        Logger.log("Failed login. Password: " + new String(this.txtPassword.getPassword()));
                    }
                } else {
                    Logger.log("Failed login. Password: " + new String(this.txtPassword.getPassword()));
                }
                if (++this.failedLogins >= 5) {
                    this.locked = true;
                    this.btnOk.setEnabled(false);
                    this.tmrOpenLock = new Timer(30000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            LoginDialog.this.tmrOpenLockActionPerformed(ae);
                        }
                    });
                    this.tmrOpenLock.setRepeats(false);
                    this.tmrOpenLock.start();
                    this.remainingSeconds = 30;
                    this.changeBtnOKText(this.remainingSeconds);
                    this.tmrDisplayLock = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            LoginDialog.this.tmrDisplayLockActionPerformed(ae);
                        }
                    });
                    this.tmrDisplayLock.setRepeats(true);
                    this.tmrDisplayLock.start();
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.log("Failed to hash password: " + ex.getMessage());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.loginResult = 3;
    }

    private void btnRecoverActionPerformed(ActionEvent evt) {
        this.btnRecoverActionPerform(evt);
    }

    private void btnCancelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btnOkActionPerformed(null);
        } else if (evt.getKeyCode() == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void btnOkKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btnOkActionPerformed(null);
        } else if (evt.getKeyCode() == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void btnRecoverKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btnOkActionPerformed(null);
        } else if (evt.getKeyCode() == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void myInitComponente() {
        try {
            URL url = ResourceLoader.class.getResource("password.png");
            this.lblIcon.setIcon(new ImageIcon(url));
            this.txtPassword.requestFocus();
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
        }
    }

    public int getLoginResult() {
        return this.loginResult;
    }

    private void setCenter() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRecoverActionPerform(ActionEvent evt) {
        int answer;
        if (this.openDialog == null) {
            this.openDialog = new JFileChooser();
        }
        if ((answer = this.openDialog.showOpenDialog(this)) != 1) {
            File recoveryFile = this.openDialog.getSelectedFile();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(recoveryFile));
                String token = reader.readLine();
                String password = Utils.recoverPassword(token);
                this.txtPassword.setText(password);
            }
            catch (Exception ex) {
                Logger.log(ex.getMessage());
                JOptionPane.showMessageDialog(this, "Password recovery failed!", "Error", 0);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        Logger.log(ex.getMessage());
                    }
                }
            }
        }
    }

    private void tmrOpenLockActionPerformed(ActionEvent ae) {
        this.locked = false;
        this.btnOk.setEnabled(true);
        this.failedLogins = 0;
        this.tmrDisplayLock.stop();
        this.btnOk.setText("OK");
    }

    private void changeBtnOKText(int remainingSeconds) {
        this.btnOk.setText("OK (" + remainingSeconds + ")");
    }

    private void tmrDisplayLockActionPerformed(ActionEvent ae) {
        --this.remainingSeconds;
        this.changeBtnOKText(this.remainingSeconds);
    }
}

