/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import com.ehsunbehravesh.mypasswords.gui.MainFrame;
import com.ehsunbehravesh.mypasswords.gui.TableResultColumnModel;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SearchDialog
extends JDialog {
    private String countCaption = "Count";
    private JButton btnSearch;
    private JLabel lblCount;
    private JLabel lblTag;
    private JLabel lblTitle;
    private JPanel pnlMain;
    private JScrollPane scpResults;
    private JTable tblResult;
    private JTextField txtTags;
    private JTextField txtTitle;
    JPopupMenu mnuResults;
    JMenuItem mniEdit;
    JMenuItem mniDelete;

    public SearchDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.myInitComponent();
        Utils.setCenterOfParent((JFrame)this.getParent(), (JDialog)this);
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.lblTitle = new JLabel();
        this.txtTitle = new JTextField();
        this.lblTag = new JLabel();
        this.txtTags = new JTextField();
        this.scpResults = new JScrollPane();
        this.tblResult = new JTable();
        this.btnSearch = new JButton();
        this.lblCount = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Search");
        this.setResizable(false);
        this.pnlMain.setBackground(new Color(255, 255, 255));
        this.lblTitle.setText("Title:");
        this.txtTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchDialog.this.txtTitleKeyReleased(evt);
            }
        });
        this.lblTag.setText("Tag:");
        this.txtTags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SearchDialog.this.txtTagsKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchDialog.this.txtTagsKeyReleased(evt);
            }
        });
        this.scpResults.setBorder(BorderFactory.createEtchedBorder());
        this.tblResult.setAutoCreateRowSorter(true);
        this.tblResult.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tblResult.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title", "Username", "URL", "ID"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchDialog.this.tblResultMouseClicked(evt);
            }
        });
        this.scpResults.setViewportView(this.tblResult);
        this.btnSearch.setText("Search");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.btnSearchActionPerformed(evt);
            }
        });
        this.btnSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SearchDialog.this.btnSearchKeyPressed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle).addComponent(this.lblTag)).addGap(36, 36, 36).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtTags).addComponent(this.txtTitle, -1, 379, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.scpResults, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, pnlMainLayout.createSequentialGroup().addComponent(this.lblCount, -2, 374, -2).addGap(24, 24, 24).addComponent(this.btnSearch, -2, 83, -2)))).addGap(34, 34, 34)));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblTitle).addComponent(this.txtTitle, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblTag).addComponent(this.txtTags, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.btnSearch).addGap(26, 26, 26)).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.lblCount, -2, 14, -2).addGap(18, 18, 18))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scpResults, -2, 299, -2).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -2, -1, -2));
        this.pack();
    }

    private void txtTitleKeyReleased(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.doSearch();
        } else if (key == 27) {
            this.closeDialog();
        }
    }

    private void txtTagsKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 44) {
            this.txtTags.setSelectionStart(this.txtTags.getText().length());
            this.txtTags.setSelectionEnd(this.txtTags.getText().length());
        }
    }

    private void txtTagsKeyReleased(KeyEvent evt) {
        String candidTag;
        int key = evt.getKeyCode();
        if (key >= 33 && key <= 40) {
            return;
        }
        if (key == 8) {
            return;
        }
        if (key == 10) {
            if (this.txtTags.getSelectedText() != null) {
                this.txtTags.setSelectionStart(this.txtTags.getText().length());
                this.txtTags.setSelectionEnd(this.txtTags.getText().length());
            } else {
                this.doSearch();
            }
        } else if (key == 27) {
            this.closeDialog();
        }
        String lastTag = "";
        StringTokenizer tokenTags = new StringTokenizer(this.txtTags.getText(), ",");
        while (tokenTags.hasMoreTokens()) {
            lastTag = tokenTags.nextToken().trim();
        }
        if (lastTag.length() > 1 && (candidTag = this.searchInTags(lastTag)).length() > 0) {
            String restOfCandidTag = Utils.getRestOfStrings(lastTag, candidTag);
            this.txtTags.setText(this.txtTags.getText() + restOfCandidTag);
            this.txtTags.setSelectionStart(this.txtTags.getText().lastIndexOf(restOfCandidTag));
            this.txtTags.setSelectionEnd(this.txtTags.getText().length());
        }
    }

    private void tblResultMouseClicked(MouseEvent evt) {
        int row = this.tblResult.getSelectedRow();
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (evt.getClickCount() == 2 && row >= 0) {
                this.showPassword();
            }
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            Point point = evt.getPoint();
            int rowNumber = this.tblResult.rowAtPoint(point);
            ListSelectionModel model = this.tblResult.getSelectionModel();
            model.setSelectionInterval(rowNumber, rowNumber);
            this.mnuResults.show(this.tblResult, point.x, point.y);
        }
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        this.doSearch();
    }

    private void btnSearchKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.doSearch();
        } else if (key == 27) {
            this.closeDialog();
        }
    }

    private String searchInTags(String keyword) {
        PasswordTag[] tags = PasswordTag.getAllTags();
        for (int i = 0; i < tags.length; ++i) {
            PasswordTag passwordTag = tags[i];
            String tagTitle = passwordTag.getTitle();
            if (tagTitle.indexOf(keyword.toLowerCase()) != 0) continue;
            return tagTitle;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearch() {
        DefaultTableModel model = (DefaultTableModel)this.tblResult.getModel();
        int numrows = model.getRowCount();
        for (int i = numrows - 1; i >= 0; --i) {
            model.removeRow(i);
        }
        Domain domain = Domain.getInstance();
        Connection con = null;
        try {
            con = domain.getDBConnection();
            Statement st = con.createStatement();
            String sql = "SELECT DISTINCT pe.* FROM PASSWORD_ENTRY pe LEFT OUTER JOIN PASSWORD_ENTRY_PASSWORD_TAG pept ON (pe.ID = pept.PASSWORD_ENTRY_ID) LEFT OUTER JOIN PASSWORD_TAG pt ON (pt.ID = pept.PASSWORD_TAG_ID) WHERE 1 = 1";
            sql = sql + (this.txtTitle.getText().trim().length() > 0 ? " AND UPPER (pe.TITLE) LIKE UPPER('%" + this.txtTitle.getText().trim() + "%')" : "");
            sql = sql + this.makeWhereClauseOfTags();
            int count = 0;
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                ++count;
                ((DefaultTableModel)this.tblResult.getModel()).addRow(new Object[]{rs.getString("title"), rs.getString("username"), rs.getString("url"), rs.getInt("id")});
            }
            this.lblCount.setText(this.countCaption + ": " + count);
        }
        catch (SQLException ex) {
            Logger.log(ex.getMessage());
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
    }

    private String makeWhereClauseOfTags() {
        String strTags = this.txtTags.getText().trim();
        if (strTags.length() <= 0) {
            return "";
        }
        String result = "";
        StringTokenizer tokenTags = new StringTokenizer(strTags, ",");
        while (tokenTags.hasMoreTokens()) {
            String tag = tokenTags.nextToken().trim().toLowerCase();
            result = String.format(" AND pt.TITLE LIKE ('%s')", tag);
        }
        return result;
    }

    private void myInitComponent() {
        TableResultColumnModel columnModel = new TableResultColumnModel();
        this.tblResult.setColumnModel(columnModel);
        this.tblResult.createDefaultColumnsFromModel();
        TableColumn column = columnModel.getColumnByModelIndex(3);
        columnModel.setColumnVisible(column, false);
        this.mnuResults = new JPopupMenu();
        URL url = ResourceLoader.class.getResource("edit.png");
        this.mniEdit = new JMenuItem("Edit", new ImageIcon(url));
        url = ResourceLoader.class.getResource("delete.png");
        this.mniDelete = new JMenuItem("Delete", new ImageIcon(url));
        this.mnuResults.add(this.mniEdit);
        this.mnuResults.add(this.mniDelete);
        ActionListener listenerForMenuItems = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SearchDialog.this.mniEdit) {
                    SearchDialog.this.showPassword();
                } else {
                    SearchDialog.this.deletePassword();
                }
            }
        };
        this.mniEdit.addActionListener(listenerForMenuItems);
        this.mniDelete.addActionListener(listenerForMenuItems);
        this.txtTitle.requestFocus();
        MainFrame mainFrame = (MainFrame)this.getParent();
        if (mainFrame.getCurrentLanguage() != null) {
            this.changeLanguage(mainFrame.getCurrentLanguage());
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void showPassword() {
        int row = this.tblResult.getSelectedRow();
        if ((row = this.tblResult.convertRowIndexToModel(row)) >= 0) {
            DefaultTableModel model = (DefaultTableModel)this.tblResult.getModel();
            Integer id = (Integer)model.getValueAt(row, 3);
            PasswordEntry passwordEntry = new PasswordEntry(id);
            passwordEntry.load();
            MainFrame owner = (MainFrame)this.getOwner();
            owner.setPasswordEntry(passwordEntry);
            owner.displayPasswordEntry();
            this.closeDialog();
        }
    }

    private void deletePassword() {
        int row = this.tblResult.getSelectedRow();
        if ((row = this.tblResult.convertRowIndexToModel(row)) >= 0) {
            DefaultTableModel model = (DefaultTableModel)this.tblResult.getModel();
            Integer id = (Integer)model.getValueAt(row, 3);
            PasswordEntry passwordEntry = new PasswordEntry(id);
            passwordEntry.load();
            int answer = JOptionPane.showConfirmDialog(this, "Do you want to delete this password?", "Delete", 0, 3);
            if (answer == 0) {
                if (passwordEntry.delete()) {
                    model.removeRow(row);
                } else {
                    JOptionPane.showMessageDialog(this, "Error occured!\n Take a look at log file for more details.", "Error", 0);
                }
            }
        }
    }

    private void changeLanguage(Properties currentLanguage) {
        try {
            this.setDirection(currentLanguage.getProperty("direction"));
            this.setTitle(currentLanguage.getProperty("Search"));
            this.lblTitle.setText(currentLanguage.getProperty("Title") + ":");
            this.lblTag.setText(currentLanguage.getProperty("Tag") + ":");
            this.btnSearch.setText(currentLanguage.getProperty("Search"));
            this.countCaption = currentLanguage.getProperty("Count");
            TableColumnModel columnModel = this.tblResult.getTableHeader().getColumnModel();
            columnModel.getColumn(0).setHeaderValue(currentLanguage.getProperty("Title"));
            columnModel.getColumn(1).setHeaderValue(currentLanguage.getProperty("Username"));
            columnModel.getColumn(2).setHeaderValue(currentLanguage.getProperty("URL"));
            this.refresh();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error occured in changing language!", "Error", 0);
        }
    }

    private void setDirection(String direction) {
        block3: {
            block2: {
                if (!direction.equals("rtl")) break block2;
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.pnlMain.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                    Component component = this.pnlMain.getComponents()[i];
                    component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                break block3;
            }
            if (!direction.equals("ltr")) break block3;
            this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.pnlMain.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                Component component = this.pnlMain.getComponents()[i];
                component.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
    }

    private void refresh() {
        this.pnlMain.setVisible(false);
        this.pnlMain.setVisible(true);
    }
}

