/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.io;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.io.FileEncryptorMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Observable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class FileEncryptor
extends Observable
implements Runnable {
    public static final int MODE_ENCRYPTION = 1;
    public static final int MODE_DECRYPTION = 2;
    private int mode;
    private int bufferSize;
    private byte[] key;
    private File sourceFile;
    private File destinationFile;
    private Long sizeOfSourceFile;
    private Long sizeOfDestinationFile;

    public FileEncryptor(int mode, byte[] key, File sourceFile, File destinationFile, int bufferSize) {
        this.mode = mode;
        this.key = key;
        this.bufferSize = (int)(mode == 1 ? (double)bufferSize : (Math.floor(bufferSize / 16) + 1.0) * 16.0);
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
        this.sizeOfSourceFile = sourceFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean noError = true;
        try {
            try {
                fileInputStream = new FileInputStream(this.sourceFile);
                try {
                    fileOutputStream = new FileOutputStream(this.destinationFile);
                    byte[] buffer = new byte[this.bufferSize];
                    byte[] realReadData = null;
                    byte[] writingData = null;
                    int readBytes = -1;
                    try {
                        while ((readBytes = fileInputStream.read(buffer)) != -1) {
                            realReadData = new byte[readBytes];
                            System.arraycopy(buffer, 0, realReadData, 0, realReadData.length);
                            buffer = new byte[this.bufferSize];
                            if (this.mode == 1) {
                                try {
                                    writingData = this.encrypt(realReadData);
                                }
                                catch (Exception ex) {
                                    noError = false;
                                    this.setChanged();
                                    this.notifyObservers(new FileEncryptorMessage(4, ex.getMessage()));
                                }
                            } else if (this.mode == 2) {
                                try {
                                    writingData = this.deccrypt(realReadData);
                                }
                                catch (Exception ex) {
                                    noError = false;
                                    this.setChanged();
                                    this.notifyObservers(new FileEncryptorMessage(5, ex.getMessage()));
                                }
                            }
                            try {
                                fileOutputStream.write(writingData);
                            }
                            catch (IOException ex) {
                                noError = false;
                                this.setChanged();
                                this.notifyObservers(new FileEncryptorMessage(6, ex.getMessage()));
                            }
                            this.setChanged();
                            this.notifyObservers(new FileEncryptorMessage(1));
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException ex) {
                                Logger.log(ex.getMessage());
                            }
                        }
                    }
                    catch (IOException ex) {
                        noError = false;
                        this.setChanged();
                        this.notifyObservers(new FileEncryptorMessage(3, ex.getMessage()));
                    }
                }
                catch (FileNotFoundException ex) {
                    noError = false;
                    this.setChanged();
                    this.notifyObservers(new FileEncryptorMessage(6, ex.getMessage()));
                }
            }
            catch (FileNotFoundException ex) {
                noError = false;
                this.setChanged();
                this.notifyObservers(new FileEncryptorMessage(3, ex.getMessage()));
            }
        }
        catch (Exception ex) {
            if (noError) {
                noError = false;
                this.setChanged();
                this.notifyObservers(new FileEncryptorMessage(7, ex.getMessage()));
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ex) {
                    Logger.log(ex.getMessage());
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
        if (noError) {
            this.sizeOfDestinationFile = this.destinationFile.length();
            this.setChanged();
            this.notifyObservers(new FileEncryptorMessage(2));
        }
    }

    private byte[] encrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = Cipher.getInstance("AES");
        SecretKeySpec k = new SecretKeySpec(this.key, "AES");
        c.init(1, k);
        byte[] byteEncrypted = c.doFinal(data);
        return byteEncrypted;
    }

    private byte[] deccrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = Cipher.getInstance("AES");
        SecretKeySpec k = new SecretKeySpec(this.key, "AES");
        c.init(2, k);
        byte[] byteText = c.doFinal(data);
        return byteText;
    }

    public Long getSizeOfDestinationFile() {
        return this.sizeOfDestinationFile;
    }

    public Long getSizeOfSourceFile() {
        return this.sizeOfSourceFile;
    }
}

