/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.resource;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.exportimport.XMLExporter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ExportDialog
extends JDialog
implements Observer {
    private XMLExporter exporter;
    private JButton btnCancel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lblStatus;
    private JProgressBar prgExport;

    public ExportDialog(Frame parent, boolean modal, File file, String key, boolean encryptAllFields) {
        super(parent, modal);
        this.exporter = new XMLExporter(file, key, encryptAllFields);
        this.initComponents();
        this.myInitComponents();
        Utils.setCenterOfParent((JFrame)this.getParent(), (JDialog)this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnCancel = new JButton();
        this.lblStatus = new JLabel();
        this.prgExport = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export");
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.jPanel1.setBackground(new Color(254, 254, 254));
        this.btnCancel.setFont(new Font("Tahoma", 0, 13));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.lblStatus.setFont(new Font("Tahoma", 0, 10));
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Export to XML");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(31, 31, 31).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblStatus, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addComponent(this.btnCancel, -2, 117, -2)).addComponent(this.prgExport, -2, 312, -2))).addGap(31, 31, 31)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(35, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.prgExport, -2, -1, -2).addGap(17, 17, 17).addComponent(this.lblStatus, -2, 29, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(105, 105, 105).addComponent(this.btnCancel))).addContainerGap(37, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void myInitComponents() {
        this.btnCancel.requestFocus();
        this.prgExport.setMinimum(this.exporter.getMinProgress());
        this.prgExport.setMaximum(this.exporter.getMaxProgress());
        this.prgExport.setValue(this.exporter.getProgress());
        this.exporter.addObserver(this);
        Thread thread = new Thread(this.exporter);
        thread.start();
        Logger.log("Export started: " + this.exporter.getFile().getAbsolutePath());
    }

    @Override
    public void update(Observable o, Object arg) {
        this.prgExport.setValue(this.exporter.getProgress());
        this.lblStatus.setText(this.exporter.getProgressPercent() + "%");
        if (this.exporter.getProgress() == this.exporter.getMaxProgress()) {
            this.btnCancel.setText("Close");
            this.lblStatus.setText(String.format("%s - Passwords: %d, Tags: %d", this.lblStatus.getText(), this.exporter.getPasswords().length, this.exporter.getTags().length));
            Logger.log("Export finished: " + this.exporter.getFile().getAbsolutePath());
            Logger.log(String.format("PasswordsCount: %d - TagsCount: %d", this.exporter.getPasswords().length, this.exporter.getTags().length));
        }
    }
}

